/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_otherPlayers", name="Dynamic Lights Other Player Light", version="1.0.2", dependencies="after:DynamicLights")
public class PlayerOthersLightSource {
    private Minecraft mcinstance;
    private long nextUpdate;
    private long updateInterval;
    private ArrayList trackedPlayers;
    private Thread thread;
    private boolean threadRunning;
    private HashMap itemsMap;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        String[] tokens;
        this.itemsMap = new HashMap();
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property itemsList = config.get("general", "LightItems", "50:15,89:12,348:10,91:15,327:15,76:10,331:10,314:14");
        itemsList.comment = "Item IDs that shine light while held. Armor Items also work when worn. [ONLY ON OTHERS] Syntax: ItemID:LightValue, seperated by commas";
        Property updateI = config.get("general", "update Interval", 1000);
        updateI.comment = "Update Interval time for all other player entities in milliseconds. The lower the better and costlier.";
        this.updateInterval = updateI.getInt();
        for (String pair : tokens = itemsList.value.split(",")) {
            String[] values = pair.split(":");
            int id = Integer.valueOf(values[0]);
            int value = Integer.valueOf(values[1]);
            System.out.println("Dynamic Lights: Read Item ID " + id + " with light value " + value + " for handheld Items!");
            this.itemsMap.put(id, value);
        }
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedPlayers = new ArrayList();
        this.threadRunning = false;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private int getLightFromItemStack(um stack) {
        Integer i;
        if (stack != null && (i = (Integer)this.itemsMap.get(stack.c)) != null) {
            return i;
        }
        return 0;
    }

    private class OtherPlayerAdapter
    implements IDynamicLightSource {
        private qx player;
        private int lightLevel = 0;
        private boolean enabled = false;

        public OtherPlayerAdapter(qx p) {
            this.player = p;
        }

        public void onTick() {
            int prevLight = this.lightLevel;
            this.lightLevel = PlayerOthersLightSource.this.getLightFromItemStack(this.player.bT());
            for (um armor : this.player.bI.b) {
                this.lightLevel = Math.max(this.lightLevel, PlayerOthersLightSource.this.getLightFromItemStack(armor));
            }
            if (prevLight != 0 && this.lightLevel != prevLight) {
                this.lightLevel = 0;
            } else if (this.player.af()) {
                this.lightLevel = 15;
            }
            if (!this.enabled && this.lightLevel > 8) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 9) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public lq getAttachmentEntity() {
            return this.player;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }

    private class OtherPlayerChecker
    extends Thread {
        private final Object[] list;

        public OtherPlayerChecker(List input) {
            this.list = input.toArray();
        }

        @Override
        public void run() {
            ArrayList<OtherPlayerAdapter> newList = new ArrayList<OtherPlayerAdapter>();
            for (Object o : this.list) {
                lq ent = (lq)o;
                if (!(ent instanceof azw) || !ent.S()) continue;
                boolean found = false;
                Iterator iter = PlayerOthersLightSource.this.trackedPlayers.iterator();
                OtherPlayerAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (OtherPlayerAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)ent)) continue;
                    adapter.onTick();
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                adapter = new OtherPlayerAdapter((qx)ent);
                adapter.onTick();
                newList.add(adapter);
            }
            PlayerOthersLightSource.this.trackedPlayers = newList;
            PlayerOthersLightSource.this.threadRunning = false;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet type, Object ... tickData) {
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (((PlayerOthersLightSource)PlayerOthersLightSource.this).mcinstance.e != null && System.currentTimeMillis() > PlayerOthersLightSource.this.nextUpdate && !DynamicLights.globalLightsOff()) {
                PlayerOthersLightSource.this.nextUpdate = System.currentTimeMillis() + PlayerOthersLightSource.this.updateInterval;
                if (!PlayerOthersLightSource.this.threadRunning) {
                    PlayerOthersLightSource.this.thread = new OtherPlayerChecker(((PlayerOthersLightSource)PlayerOthersLightSource.this).mcinstance.e.e);
                    PlayerOthersLightSource.this.thread.setPriority(1);
                    PlayerOthersLightSource.this.thread.start();
                    PlayerOthersLightSource.this.threadRunning = true;
                }
            }
        }

        public EnumSet ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_otherPlayers";
        }
    }
}

