/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.kr4mer.p.Uberjump;

import com.gmail.kr4mer.p.Uberjump.UberJumpSession;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public final class Uberjump
extends JavaPlugin
implements Listener {
    int maxHeight;
    int minHeight;
    Map<String, UberJumpSession> PlayerList = new HashMap<String, UberJumpSession>();

    public void onEnable() {
        this.maxHeight = 50;
        this.minHeight = -10;
        this.getLogger().info("Has been enabled!");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Player[] OnlinePlayers = Bukkit.getOnlinePlayers();
        int x = 0;
        while (x < OnlinePlayers.length) {
            String name = OnlinePlayers[x].getDisplayName();
            OnlinePlayers[x].removePotionEffect(PotionEffectType.JUMP);
            this.PlayerList.put(name, null);
            this.getLogger().info(name);
            ++x;
        }
    }

    public void onDisable() {
        this.getLogger().info("Has been disabled!");
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        String name = event.getPlayer().getDisplayName();
        this.PlayerList.put(name, null);
        event.getPlayer().removePotionEffect(PotionEffectType.JUMP);
    }

    public void onPlayerLeave(PlayerQuitEvent event) {
        String name = event.getPlayer().getDisplayName();
        if (this.PlayerList.get(name) != null) {
            this.PlayerList.get(name).endSession(true);
            this.PlayerList.put(name, null);
        }
    }

    private int getMaxHeight(Player player) {
        int maxValue = 1;
        int h = this.minHeight;
        while (h <= this.maxHeight) {
            if (player.hasPermission("uberjump.maximum." + h)) {
                maxValue = h;
            }
            ++h;
        }
        return maxValue;
    }

    private int getMinHeight(Player player) {
        int maxValue = 0;
        int h = this.maxHeight;
        while (h >= this.minHeight) {
            if (player.hasPermission("uberjump.minimum." + h)) {
                maxValue = h;
            }
            --h;
        }
        return maxValue;
    }

    public void setUberjump(Player player, int time, int height) {
        UberJumpSession entry = this.PlayerList.get(player.getDisplayName());
        if (entry == null || entry.hasEnded()) {
            UberJumpSession UJS = new UberJumpSession(player, time, height);
            this.scheduleSessionEnd(UJS);
            this.PlayerList.put(player.getDisplayName(), UJS);
            player.sendMessage(ChatColor.GREEN + "Uberjump enabled - " + height + " Block(s), " + time + " Tick(s) or ~" + time / 20 + " Second(s)");
        } else {
            entry.endSession(true);
        }
    }

    private void scheduleSessionEnd(final UberJumpSession session) {
        Plugin UJ = this.getServer().getPluginManager().getPlugin("Uberjump");
        this.getServer().getScheduler().scheduleSyncDelayedTask(UJ, new Runnable(){

            public void run() {
                session.endSession();
            }
        }, session.lasts_ticks);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("uj")) return false;
        if (!(sender instanceof Player)) {
            sender.sendMessage("/uj is a Player-Only command.");
            return true;
        }
        if (args.length == 0) {
            if (!sender.hasPermission("uberjump.change.self")) {
                sender.sendMessage(ChatColor.RED + "You do not have permission to use this command. (" + ChatColor.WHITE + "uberjump.change.self" + ChatColor.RED + ")");
                return false;
            }
            if (this.getMinHeight((Player)sender) <= 1 && this.getMaxHeight((Player)sender) >= 1) {
                this.setUberjump((Player)sender, 600, 1);
                return false;
            }
            this.setUberjump((Player)sender, 600, this.getMinHeight((Player)sender));
            return false;
        }
        if (args.length < 1) return false;
        int height = 1;
        int time = 1200;
        Player player = (Player)sender;
        int a = 0;
        while (a < args.length) {
            if (args[a].startsWith("-t")) {
                if (!sender.hasPermission("uberjump.change.time")) {
                    sender.sendMessage(ChatColor.RED + "You do not have permission to change the effect time. (" + ChatColor.WHITE + "uberjump.change.time" + ChatColor.RED + ")");
                    return false;
                }
                if (!this.isIntNumber(args[a].substring(2))) {
                    sender.sendMessage(ChatColor.DARK_RED + "'" + args[a].substring(2) + "' - Expected Integer.");
                    return false;
                }
                time = Integer.parseInt(args[a].substring(2));
            } else if (args[a].startsWith("-h")) {
                if (!sender.hasPermission("uberjump.change.height")) {
                    sender.sendMessage(ChatColor.RED + "You do not have permission to change the effect height. (" + ChatColor.WHITE + "uberjump.change.height" + ChatColor.RED + ")");
                    return false;
                }
                if (!this.isIntNumber(args[a].substring(2))) {
                    sender.sendMessage(ChatColor.DARK_RED + "'" + args[a].substring(2) + "' - Expected Integer.");
                    return false;
                }
                height = Integer.parseInt(args[a].substring(2));
            } else {
                if (!sender.hasPermission("uberjump.change.other")) {
                    sender.sendMessage(ChatColor.RED + "You do not have permission to change Uberjump for other players. (" + ChatColor.WHITE + "uberjump.change.other" + ChatColor.RED + ")");
                    return false;
                }
                player = this.getPlayer(args[a]);
                if (player == null) {
                    sender.sendMessage(ChatColor.RED + "Player '" + args[a] + "' not found.");
                    return false;
                }
            }
            ++a;
        }
        if (this.getMaxHeight((Player)sender) >= height && this.getMinHeight((Player)sender) <= height) {
            this.setUberjump(player, time * 20, height);
            return false;
        }
        if (this.getMaxHeight((Player)sender) < height) {
            sender.sendMessage(ChatColor.RED + "You don't have permission for this jump height. (max. height " + this.getMaxHeight((Player)sender) + ").");
            return false;
        }
        sender.sendMessage(ChatColor.RED + "You don't have permission for this jump height. (min. height " + this.getMinHeight((Player)sender) + ").");
        return false;
    }

    private Player getPlayer(String name) {
        Object[] OnlinePlayers = Bukkit.matchPlayer((String)name).toArray();
        if (OnlinePlayers.length > 0) {
            return (Player)OnlinePlayers[0];
        }
        return null;
    }

    private boolean isIntNumber(String num) {
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

