/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.bspkrscore.fml.bspkrsCoreMod;
import bspkrs.treecapitator.CommonProxy;
import bspkrs.treecapitator.Treecapitator;
import bspkrs.treecapitator.compat.MultiMineCompat;
import bspkrs.treecapitator.config.TCConfigHandler;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.forge.ForgeEventHandler;
import bspkrs.treecapitator.forge.OreDictionaryHandler;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.registry.RegistryNBTManager;
import bspkrs.treecapitator.registry.ThirdPartyModConfig;
import bspkrs.treecapitator.registry.ToolRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BSConfiguration;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.Coord;
import bspkrs.util.ModVersionChecker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="TreeCapitator", modid="TreeCapitator", version="1.7.2.r01", dependencies="required-after:bspkrsCore", useMetadata=true)
public class TreecapitatorMod {
    public static ModVersionChecker versionChecker;
    private final String versionURL = "http://dl.dropboxusercontent.com/u/20748481/Minecraft/1.7.2/treeCapitatorForge.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/1009577-";
    private RegistryNBTManager nbtManager;
    public BSConfiguration config;
    @Mod.Metadata(value="TreeCapitator")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="bspkrs.treecapitator.ClientProxy", serverSide="bspkrs.treecapitator.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="TreeCapitator")
    public static TreecapitatorMod instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        File file = event.getSuggestedConfigurationFile();
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        TCConfigHandler.setInstance(file);
        if (!CommonUtils.isObfuscatedEnv()) {
            TCSettings.allowDebugLogging = true;
        }
        if (bspkrsCoreMod.instance.allowUpdateCheck) {
            versionChecker = new ModVersionChecker(TreecapitatorMod.metadata.name, TreecapitatorMod.metadata.version, "http://dl.dropboxusercontent.com/u/20748481/Minecraft/1.7.2/treeCapitatorForge.version", "http://www.minecraftforum.net/topic/1009577-");
            versionChecker.checkVersionWithLogging();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        proxy.init(event);
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages().asList()) {
            if (msg.isNBTMessage()) {
                TCLog.info("Received IMC message from mod %s.", msg.getSender());
                ModConfigRegistry.instance().registerIMCModConfig(new ThirdPartyModConfig(msg.getNBTValue()));
                continue;
            }
            TCLog.warning("Mod %s send an IMC message, but it is not an NBT object message. The message will be ignored.", msg.getSender());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        TreeRegistry.instance().readBlacklistFromDelimitedString(TCSettings.blockIDBlacklist);
        ToolRegistry.instance().readBlacklistFromDelimitedString(TCSettings.itemIDBlacklist);
        ModConfigRegistry.instance().applyPrioritizedModConfigs();
        OreDictionaryHandler.instance().generateAndRegisterOreDictionaryTreeDefinitions();
        if (Loader.isModLoaded((String)TCSettings.multiMineModID)) {
            TCLog.info("Initializing MultiMine compatibility...", new Object[0]);
            new MultiMineCompat(TreeRegistry.instance().getMultiMineExclusionString());
        }
        this.nbtManager();
    }

    public void onBlockHarvested(World world, int x, int y, int z, Block block, int metadata, EntityPlayer entityPlayer) {
        if (proxy.isEnabled() && !world.field_72995_K) {
            BlockID blockID = new BlockID(block, metadata);
            if (TreeRegistry.instance().isRegistered(blockID)) {
                Coord blockPos = new Coord(x, y, z);
                if (TreeRegistry.instance().trackTreeChopEventAt(blockPos)) {
                    TCLog.debug("BlockID " + blockID + " is a log.", new Object[0]);
                    if (Treecapitator.isBreakingEnabled(entityPlayer) && Treecapitator.isBreakingPossible(world, entityPlayer, true)) {
                        TreeDefinition treeDef = TreeRegistry.instance().get(blockID);
                        if (treeDef != null) {
                            Treecapitator breaker = new Treecapitator(entityPlayer, treeDef);
                            breaker.onBlockHarvested(world, x, y, z, metadata, entityPlayer);
                        } else {
                            TCLog.severe("TreeRegistry reported block ID %s is a log, but TreeDefinition lookup failed! Please report this to bspkrs (include a copy of this log file and your config).", blockID);
                        }
                    } else {
                        TCLog.debug("Chopping disabled due to player state or gamemode.", new Object[0]);
                    }
                    TreeRegistry.instance().endTreeChopEventAt(blockPos);
                } else {
                    TCLog.debug("Previous chopping event detected for block @%s", blockPos.toString());
                }
            }
        }
    }

    public RegistryNBTManager nbtManager() {
        if (this.nbtManager == null) {
            this.nbtManager = new RegistryNBTManager();
        }
        return this.nbtManager;
    }
}

