/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.forge;

import bspkrs.helpers.block.BlockHelper;
import bspkrs.helpers.entity.player.EntityPlayerHelper;
import bspkrs.helpers.world.WorldHelper;
import bspkrs.treecapitator.Treecapitator;
import bspkrs.treecapitator.TreecapitatorMod;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ForgeEventHandler {
    private Map<String, Boolean> playerSneakingMap = new HashMap<String, Boolean>();

    @SubscribeEvent
    public void onBlockClicked(PlayerInteractEvent event) {
        if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) && TreecapitatorMod.proxy.isEnabled() && WorldHelper.isAirBlock((World)event.entityPlayer.field_70170_p, (int)event.x, (int)event.y, (int)event.z)) {
            Block block = WorldHelper.getBlock((World)event.entityPlayer.field_70170_p, (int)event.x, (int)event.y, (int)event.z);
            int metadata = event.entityPlayer.field_70170_p.func_72805_g(event.x, event.y, event.z);
            if (TCSettings.allowDebugOutput && event.entityPlayer.func_70093_af() && block != null) {
                TreecapitatorMod.proxy.debugOutputBlockID(BlockHelper.getUniqueID((Block)block), metadata);
            }
            this.playerSneakingMap.put(EntityPlayerHelper.getGameProfile((EntityPlayer)event.entityPlayer).getName(), event.entityPlayer.func_70093_af());
        }
    }

    @SubscribeEvent
    public void getPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockID blockID = new BlockID(event.block, event.metadata);
        if (TreecapitatorMod.proxy.isEnabled() && TreeRegistry.instance().isRegistered(blockID) && Treecapitator.isAxeItemEquipped(event.entityPlayer)) {
            TreeDefinition treeDef = TreeRegistry.instance().get(blockID);
            if (treeDef != null) {
                if (TCSettings.treeHeightDecidesBreakSpeed) {
                    MovingObjectPosition thing = CommonUtils.getPlayerLookingSpot((EntityPlayer)event.entityPlayer, (boolean)true);
                    if (thing != null && thing.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                        if (this.playerSneakingMap.containsKey(EntityPlayerHelper.getGameProfile((EntityPlayer)event.entityPlayer)) && this.playerSneakingMap.get(EntityPlayerHelper.getGameProfile((EntityPlayer)event.entityPlayer)).booleanValue() == event.entityPlayer.func_70093_af() || !this.playerSneakingMap.containsKey(EntityPlayerHelper.getGameProfile((EntityPlayer)event.entityPlayer))) {
                            int height;
                            if (Treecapitator.isBreakingEnabled(event.entityPlayer) && (height = Treecapitator.getTreeHeight(treeDef, event.entityPlayer.field_70170_p, thing.field_72311_b, thing.field_72312_c, thing.field_72309_d, event.metadata, event.entityPlayer)) > 1) {
                                event.newSpeed = event.originalSpeed / ((float)height * TCSettings.treeHeightModifier);
                            }
                        } else {
                            event.newSpeed = 1.0E-10f;
                        }
                    }
                } else {
                    event.newSpeed = event.originalSpeed * treeDef.breakSpeedModifier();
                }
            } else {
                TCLog.severe("TreeRegistry reported block ID %s is a log, but TreeDefinition lookup failed! Please report this to bspkrs (include a copy of this log file and your config).", blockID);
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.BreakEvent event) {
        if (event.block != null && event.world != null && event.getPlayer() != null) {
            TreecapitatorMod.instance.onBlockHarvested(event.world, event.x, event.y, event.z, event.block, event.blockMetadata, event.getPlayer());
        }
    }
}

