/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.treecapitator.config.TCConfigHandler;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ThirdPartyModConfig;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BSConfiguration;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ModConfigRegistry {
    private static ModConfigRegistry instance;
    private Map<String, ThirdPartyModConfig> userModCfgs;
    private Map<String, ThirdPartyModConfig> imcModCfgs;
    private Map<String, ThirdPartyModConfig> defaultModCfgs;

    public static ModConfigRegistry instance() {
        if (instance == null) {
            new ModConfigRegistry();
        }
        return instance;
    }

    protected ModConfigRegistry() {
        instance = this;
        this.userModCfgs = new HashMap<String, ThirdPartyModConfig>();
        this.imcModCfgs = new HashMap<String, ThirdPartyModConfig>();
        this.initDefaultModConfigs();
    }

    public void registerUserModConfig(ThirdPartyModConfig tpmc) {
        TCLog.debug("Registering user mod config %s", tpmc.modID());
        if (!this.userModCfgs.containsKey(tpmc.modID())) {
            this.userModCfgs.put(tpmc.modID(), tpmc);
        } else {
            TCLog.warning("User config contains multiple 3rd party mod configs for mod id \"%s\".  The first entry will be used.", tpmc.modID());
        }
    }

    public void registerIMCModConfig(ThirdPartyModConfig tpmc) {
        TCLog.debug("Registering IMC mod config %s", tpmc.modID());
        if (!this.imcModCfgs.containsKey(tpmc.modID())) {
            this.imcModCfgs.put(tpmc.modID(), tpmc.setOverrideIMC(false));
        } else {
            TCLog.warning("Mod \"%s\" sent multiple IMC messages. The first message will be used.", tpmc.modID());
        }
    }

    public void applyPrioritizedModConfigs() {
        LinkedList<ThirdPartyModConfig> finalList = new LinkedList<ThirdPartyModConfig>();
        TCLog.info("Prioritizing User and IMC mod configs...", new Object[0]);
        for (Map.Entry<String, ThirdPartyModConfig> e : this.imcModCfgs.entrySet()) {
            if (this.userModCfgs.containsKey(e.getKey()) && this.userModCfgs.get(e.getKey()).overrideIMC()) continue;
            finalList.add(e.getValue());
            TCLog.debug("IMC mod config loaded for %s.", e.getValue().modID());
            this.writeIMCConfigToConfigFile(e.getValue());
        }
        for (Map.Entry<String, ThirdPartyModConfig> e : this.userModCfgs.entrySet()) {
            if (this.imcModCfgs.containsKey(e.getKey()) && !e.getValue().overrideIMC()) continue;
            finalList.add(e.getValue());
            TCLog.debug("User mod config loaded for %s.", e.getValue().modID());
        }
        TCLog.info("Registering items and trees...", new Object[0]);
        for (ThirdPartyModConfig cfg : finalList) {
            cfg.registerTools().registerTrees();
        }
    }

    protected void initDefaultModConfigs() {
        this.defaultModCfgs = new TreeMap<String, ThirdPartyModConfig>();
        this.defaultModCfgs.put("1_vanilla_trees_and_items", new ThirdPartyModConfig());
    }

    public Map<String, ThirdPartyModConfig> defaultConfigs() {
        return new TreeMap<String, ThirdPartyModConfig>(this.defaultModCfgs);
    }

    public void syncConfiguration(BSConfiguration config) {
        TCSettings.multiMineModID = config.getString("multiMineID", "tree_and_mod_configs", TCSettings.multiMineModID, "The mod ID value for Multi-Mine.");
        TCSettings.userConfigOverridesIMC = config.getBoolean("userConfigOverridesIMC", "tree_and_mod_configs", TCSettings.userConfigOverridesIMC, "This setting controls the default behavior when a mod is both configured manually (in the config file) and \nby the mod itself via IMC (inter-mod communication).");
        TCSettings.saveIMCConfigsToFile = config.getBoolean("saveIMCConfigsToFile", "tree_and_mod_configs", TCSettings.saveIMCConfigsToFile, "This setting controls whether or not IMC config messages sent by other mods will be saved to the local\nconfig file when they are processed by Treecapitator. The message will only be saved if your local config\nfor a given mod is not set to override the IMC message.");
        TCLog.configs((Configuration)config, "tree_and_mod_configs");
        config.addCustomCategoryComment("tree_and_mod_configs", "This category is where all your settings live that are related to 3rd party mods.\nNOTE: Using item or block number IDs WILL NOT WORK. Refer to the UniqueNames.txt file in the config folder for a list of values.\n\nHow to add new mods: \n\nKeep in mind that you can also include settings marked with [PerTree] on a per-tree basis to override the global default values.\n\nFormat:\n    <section_name> { (typically same as modID)\n        S:modID=<modID> (this can be found on the Mods screen in game or in mcmod.info)\n        S:axeIDList=<unique_item_identifier>,<optional metadata>; minecraft:wooden_axe; minecraft:stone_axe\n        S:shearsIDList=<unique_item_identifier>,<optional metadata>\n        B:overrideIMC=<optional, defaults to false) whether or not a mod's user config (this file) should override a mod's IMC config (IMC allows mods to send messages to each other for compatibility)\n\n        <tree_name> { (the tree name is just for organization and clarity)\n            # logs/leaves: list of unique block name values. \",\" separates name and metadata, \";\" separates block entries\n            S:logs=<unique block identifier>,<optional metadata>; <unique_block_identifier>,0; minecraft:log,0\n            S:leaves=<unique block identifier>,<optional metadata>; <unique_block_identifier>,0; minecraft:leaves,0\n            [optionally add per-tree settings here]\n\n        }\n    }");
        if (!config.hasCategory("tree_and_mod_configs.1_vanilla_trees_and_items")) {
            Map<String, ThirdPartyModConfig> m = this.defaultConfigs();
            for (Map.Entry<String, ThirdPartyModConfig> e : m.entrySet()) {
                e.getValue().writeToConfiguration(config, "tree_and_mod_configs." + e.getKey());
            }
            TCLog.info("Looks like a fresh config; default config loaded.", new Object[0]);
        } else {
            TCLog.info("Proceeding to load tree/mod configs from file.", new Object[0]);
        }
        config.addCustomCategoryComment("tree_and_mod_configs.1_vanilla_trees_and_items", "This special category is the home of the vanilla tree block and item configurations. You can change the \nvalues in this category to suit your preferences.\n\nWARNING: This config category must not be removed! If this category is renamed or removed TreeCapitator \nwill assume your config file is new and reload the default user mod config settings!");
        for (String ctgy : config.getCategoryNames()) {
            ConfigCategory cc = config.getCategory(ctgy);
            if (ctgy.indexOf("tree_and_mod_configs.") == -1 || !cc.containsKey("modID") || !Loader.isModLoaded((String)cc.get("modID").getString())) continue;
            TCLog.debug("Loading file config for mod %s (config category %s)...", cc.get("modID").getString(), ctgy);
            this.registerUserModConfig(new ThirdPartyModConfig(config, ctgy));
        }
    }

    public void writeIMCConfigToConfigFile(ThirdPartyModConfig imctpmc) {
        if (TCSettings.saveIMCConfigsToFile) {
            BSConfiguration config = TCConfigHandler.instance().config;
            String imcCtgy = "";
            for (String ctgy : config.getCategoryNames()) {
                ConfigCategory cc = config.getCategory(ctgy);
                if (ctgy.indexOf("tree_and_mod_configs.") == -1 || !cc.containsKey("modID") || !imctpmc.modID().equals(cc.get("modID").getString())) continue;
                imcCtgy = ctgy;
                break;
            }
            if (imcCtgy.isEmpty()) {
                imcCtgy = "tree_and_mod_configs." + imctpmc.modID();
            } else if (config.hasCategory(imcCtgy)) {
                config.removeCategory(config.getCategory(imcCtgy));
            }
            imctpmc.writeToConfiguration(config, imcCtgy);
            config.save();
        }
    }

    protected void imcSendMessageBoP() {
        if (Loader.isModLoaded((String)"TreeCapitator")) {
            NBTTagCompound tpModCfg = new NBTTagCompound();
            tpModCfg.func_74778_a("modID", "BiomesOPlenty");
            tpModCfg.func_74778_a("axeIDList", "<item:Muddy Axe ID>; <item:Amethyst Axe ID>");
            tpModCfg.func_74778_a("shearsIDList", "");
            tpModCfg.func_74757_a("useShiftedItemID", true);
            NBTTagList treeList = new NBTTagList();
            NBTTagCompound tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "vanilla_oak");
            tree.func_74778_a("logs", "");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 1>,4; <block:Leaf Block ID 1>,7; <block:Leaf Block ID 1>,12; <block:Leaf Block ID 1>,15; <block:Fruit Leaf Block ID>; <block:Leaf Block ID 2>,0; <block:Leaf Block ID 2>,8; <block:Leaf Block ID 2>,2; <block:Leaf Block ID 2>,10");
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "vanilla_birch");
            tree.func_74778_a("logs", "");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 1>,0; <block:Leaf Block ID 1>,8");
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "acacia");
            tree.func_74778_a("logs", "<block:Log Block ID 1>,0; <block:Log Block ID 1>,4; <block:Log Block ID 1>,8");
            tree.func_74778_a("leaves", "<block:Colourized Leaves ID>,0; <block:Colourized Leaves ID>,8");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "cherry");
            tree.func_74778_a("logs", "<block:Log Block ID 1>,1; <block:Log Block ID 1>,5; <block:Log Block ID 1>,9");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 2>,1; <block:Leaf Block ID 2>,3; <block:Leaf Block ID 2>,9; <block:Leaf Block ID 2>,11");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "darkwood");
            tree.func_74778_a("logs", "<block:Log Block ID 1>,2; <block:Log Block ID 1>,6; <block:Log Block ID 1>,10");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 1>,3; <block:Leaf Block ID 1>,11");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "fir");
            tree.func_74778_a("logs", "<block:Log Block ID 1>,3; <block:Log Block ID 1>,7; <block:Log Block ID 1>,11");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 1>,5; <block:Leaf Block ID 1>,13");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "holy");
            tree.func_74778_a("logs", "<block:Log Block ID 2>,0; <block:Log Block ID 2>,4; <block:Log Block ID 2>,8");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 1>,6; <block:Leaf Block ID 1>,14");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "magic");
            tree.func_74778_a("logs", "<block:Log Block ID 2>,1; <block:Log Block ID 2>,5; <block:Log Block ID 2>,9");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 1>,2; <block:Leaf Block ID 1>,10");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "mangrove");
            tree.func_74778_a("logs", "<block:Log Block ID 2>,2; <block:Log Block ID 2>,6; <block:Log Block ID 2>,10");
            tree.func_74778_a("leaves", "<block:Colourized Leaves ID>,1; <block:Colourized Leaves ID>,9");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "palm");
            tree.func_74778_a("logs", "<block:Log Block ID 2>,3; <block:Log Block ID 2>,7; <block:Log Block ID 2>,11");
            tree.func_74778_a("leaves", "<block:Colourized Leaves ID>,2; <block:Colourized Leaves ID>,10");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "redwood");
            tree.func_74778_a("logs", "<block:Log Block ID 3>,0; <block:Log Block ID 3>,4; <block:Log Block ID 3>,8");
            tree.func_74778_a("leaves", "<block:Colourized Leaves ID>,3; <block:Colourized Leaves ID>,11");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "willow");
            tree.func_74778_a("logs", "<block:Log Block ID 3>,1; <block:Log Block ID 3>,5; <block:Log Block ID 3>,9");
            tree.func_74778_a("leaves", "<block:Colourized Leaves ID>,4; <block:Colourized Leaves ID>,12");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "dead");
            tree.func_74778_a("logs", "<block:Log Block ID 3>,2; <block:Log Block ID 3>,6; <block:Log Block ID 3>,10");
            tree.func_74778_a("leaves", "");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "big_flower");
            tree.func_74778_a("logs", "<block:Log Block ID 3>,3; <block:Log Block ID 3>,7; <block:Log Block ID 3>,11");
            tree.func_74778_a("leaves", "<block:Petal ID>");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "pine");
            tree.func_74778_a("logs", "<block:Log Block ID 4>,0; <block:Log Block ID 4>,4; <block:Log Block ID 4>,8");
            tree.func_74778_a("leaves", "<block:Colourized Leaves ID>,5; <block:Colourized Leaves ID>,13");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "hellbark");
            tree.func_74778_a("logs", "<block:Log Block ID 4>,1; <block:Log Block ID 4>,5; <block:Log Block ID 4>,9");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 2>,4; <block:Leaf Block ID 2>,12");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "jacaranda");
            tree.func_74778_a("logs", "<block:Log Block ID 4>,2; <block:Log Block ID 4>,6; <block:Log Block ID 4>,10");
            tree.func_74778_a("leaves", "<block:Leaf Block ID 1>,5; <block:Leaf Block ID 1>,13");
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tpModCfg.func_74782_a("trees", (NBTBase)treeList);
            FMLInterModComms.sendMessage((String)"TreeCapitator", (String)"ThirdPartyModConfig", (NBTTagCompound)tpModCfg);
        }
    }

    protected void imcSendMessageEBXL() {
        if (Loader.isModLoaded((String)"TreeCapitator")) {
            NBTTagCompound tpModCfg = new NBTTagCompound();
            tpModCfg.func_74778_a("modID", "ExtraBiomesXL");
            tpModCfg.func_74778_a("axeIDList", "");
            tpModCfg.func_74778_a("shearsIDList", "");
            tpModCfg.func_74757_a("useShiftedItemID", true);
            NBTTagList treeList = new NBTTagList();
            NBTTagCompound tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "vanilla_oak");
            tree.func_74778_a("logs", "<block:quarterlog0.id>,2; <block:quarterlog1.id>,2; <block:quarterlog2.id>,2; <block:quarterlog3.id>,2;");
            tree.func_74778_a("leaves", "<block:autumnleaves.id>");
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "vanilla_spruce");
            tree.func_74778_a("logs", "");
            tree.func_74778_a("leaves", "<block:autumnleaves.id>");
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "fir");
            tree.func_74778_a("logs", "<block:customlog.id>,0; <block:quarterlog0.id>,1; <block:quarterlog1.id>,1; <block:quarterlog2.id>,1; <block:quarterlog3.id>,1");
            tree.func_74778_a("leaves", "<block:greenleaves.id>,0; <block:greenleaves.id>,8");
            tree.func_74768_a("maxHorLeafBreakDist", 10);
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "redwood");
            tree.func_74778_a("logs", "<block:quarterlog0.id>,0; <block:quarterlog1.id>,0; <block:quarterlog2.id>,0; <block:quarterlog3.id>,0");
            tree.func_74778_a("leaves", "<block:greenleaves.id>,1; <block:greenleaves.id>,9");
            tree.func_74768_a("maxHorLeafBreakDist", 10);
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "acacia");
            tree.func_74778_a("logs", "<block:customlog.id>,1");
            tree.func_74778_a("leaves", "<block:greenleaves.id>,2");
            treeList.func_74742_a((NBTBase)tree);
            tpModCfg.func_74782_a("trees", (NBTBase)treeList);
            FMLInterModComms.sendMessage((String)"TreeCapitator", (String)"ThirdPartyModConfig", (NBTTagCompound)tpModCfg);
        }
    }
}

