/*
 * Decompiled with CFR 0.152.
 */
package extrause.common.util;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class UtilEU {
    public static Item toItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static float getLostHealth(EntityPlayer player) {
        return player.func_110138_aP() - player.func_110143_aJ();
    }

    public static void clearInventory(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            inv.func_70298_a(j, 64);
        }
        player.field_71069_bz.func_75142_b();
    }

    public static void clearEffects(EntityLivingBase entity) {
        for (int j = 0; j < Potion.field_76425_a.length; ++j) {
            entity.func_82170_o(j);
        }
    }

    public static void addEffect(EntityLivingBase entity, Potion potion, int time, int amp, boolean ambient) {
        if (potion == null && time == 0 && amp == 0) {
            UtilEU.clearEffects(entity);
        } else {
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, time, amp, ambient));
        }
    }

    public static void entityDrop(LivingDropsEvent event, ItemStack stack) {
        EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, stack);
        entityitem.field_145804_b = 10;
        event.drops.add(entityitem);
    }

    public static void sendTranslatedMessage(EntityPlayer player, String translation) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(translation, new Object[0]));
    }

    public static void spawnItem(EntityLivingBase entity, ItemStack stack, boolean collide) {
        EntityItem eItem = new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, stack);
        if (!collide) {
            eItem.field_145804_b = 10;
        }
        entity.field_70170_p.func_72838_d((Entity)eItem);
        if (collide && entity instanceof EntityPlayer) {
            eItem.func_70100_b_((EntityPlayer)entity);
        }
    }

    public static void spawnItem(World world, double x, double y, double z, ItemStack stack) {
        EntityItem eItem = new EntityItem(world, x, y, z, stack);
        eItem.field_145804_b = 10;
        world.func_72838_d((Entity)eItem);
    }

    public static void addFreezeEffect(EntityLivingBase entity) {
        EntityLivingBase mob;
        if ((entity instanceof EntityPlayer || entity instanceof EntityZombie || entity instanceof EntitySkeleton || entity instanceof EntityGiantZombie) && (mob = entity).func_71124_b(4) != null) {
            if (mob.func_71124_b(4).func_77973_b() != Item.func_150898_a((Block)Blocks.field_150432_aD) && !entity.field_70170_p.field_72995_K) {
                UtilEU.spawnItem(entity, mob.func_71124_b(4), false);
            }
            mob.func_70062_b(4, new ItemStack(Blocks.field_150350_a));
        }
        UtilEU.addEffect(entity, Potion.field_76421_d, 100, 127, true);
        entity.func_70062_b(4, new ItemStack(Blocks.field_150432_aD));
    }

    public static void sendMessage(EntityPlayer player, String text) {
        player.func_145747_a((IChatComponent)new ChatComponentText(text));
    }

    public static boolean applyBonemeal(ItemStack stack, World world, int x, int y, int z, EntityPlayer player, boolean remove) {
        IGrowable igrowable;
        Block block = world.func_147439_a(x, y, z);
        BonemealEvent event = new BonemealEvent(player, world, block, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!world.field_72995_K) {
                --stack.field_77994_a;
            }
            return true;
        }
        if (block instanceof IGrowable && (igrowable = (IGrowable)block).func_149851_a(world, x, y, z, world.field_72995_K)) {
            if (!world.field_72995_K) {
                if (igrowable.func_149852_a(world, world.field_73012_v, x, y, z)) {
                    igrowable.func_149853_b(world, world.field_73012_v, x, y, z);
                }
                if (remove) {
                    --stack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }
}

