/*
 * Decompiled with CFR 0.152.
 */
package hats.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hats.api.RenderOnEntityHelper;
import hats.common.Hats;
import hats.common.core.CommonProxy;
import hats.common.core.HatInfo;
import hats.common.packet.PacketHatFragment;
import hats.common.packet.PacketPing;
import hats.common.packet.PacketRequestHat;
import hats.common.packet.PacketString;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import ichun.common.core.techne.TC2Info;
import ichun.common.core.util.MD5Checksum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;

public class HatHandler {
    public static boolean reloadingHats;
    public static File hatsFolder;
    public static HashMap<String, ArrayList<String>> queuedHats;
    public static HashMap<String, ArrayList<byte[]>> hatParts;
    public static HashMap<File, String> hatNames;
    public static HashMap<String, File> checksums;
    public static HashMap<String, ArrayList<String>> categories;
    public static Random rand;
    public static Random hatGen;
    private static HashMap<Class<? extends TileEntity>, Boolean> mobSpawners;
    private static HashMap<Class<? extends TileEntity>, Field> mobSpawnerLogic;

    public static boolean isHatReadable(File file) {
        if (file.getName().endsWith(".tc2")) {
            return TC2Info.readTechneFile((File)file) != null;
        }
        return false;
    }

    public static boolean readHatFromFile(File file) {
        return HatHandler.readHatFromFile(file, false);
    }

    public static boolean readHatFromFile(File file, boolean category) {
        String md5 = MD5Checksum.getMD5Checksum((File)file);
        if (checksums.get(md5) != null) {
            if (category) {
                return false;
            }
            Hats.console("Rejecting " + file.getName() + "! Identical to " + checksums.get(md5).getName(), true);
            return true;
        }
        checksums.put(md5, file);
        if (file.getName().endsWith(".tc2")) {
            TC2Info info = TC2Info.readTechneFile((File)file);
            if (info == null) {
                Hats.console("Failed to load: " + file.getName() + " threw a generic exception!", true);
                return false;
            }
            if (Hats.config.getInt("safeLoad") == 1 && info.tampered) {
                Hats.console("Rejecting " + file.getName() + "! It contains files which are not XML or PNG files!", true);
                return false;
            }
            Hats.proxy.loadHatFile(file);
            return true;
        }
        return false;
    }

    public static int loadCategory(File dir) {
        int hatCount = 0;
        if (dir.isDirectory()) {
            File[] files;
            ArrayList<String> hatsToLoad = new ArrayList<String>();
            ArrayList<String> categoryHats = new ArrayList<String>();
            for (File file : files = dir.listFiles()) {
                if (!file.getName().endsWith(".tc2")) continue;
                String hatName = file.getName().substring(0, file.getName().length() - 4);
                hatsToLoad.add(hatName.toLowerCase());
                categoryHats.add(hatName);
                block1: for (Map.Entry<File, String> e : hatNames.entrySet()) {
                    String hatEntryName = e.getValue();
                    for (int i = hatsToLoad.size() - 1; i >= 0; --i) {
                        String hatCategoryEntryName = (String)hatsToLoad.get(i);
                        if (!hatCategoryEntryName.equalsIgnoreCase(hatEntryName)) continue;
                        hatsToLoad.remove(i);
                        continue block1;
                    }
                }
                if (file.isDirectory() || !HatHandler.readHatFromFile(file, true) || dir.getName().equalsIgnoreCase("Favourites")) continue;
                ++hatCount;
            }
            categories.put(dir.getName(), categoryHats);
        }
        return hatCount;
    }

    public static void deleteHat(String hatName, boolean disable) {
        HatHandler.deleteHat(hatsFolder, hatName, disable);
    }

    public static void deleteHat(File dir, String hatName, boolean disable) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory() || !file.getName().equalsIgnoreCase(hatName + ".tc2")) continue;
            if (disable) {
                File disabledName;
                File disabledDir = new File(dir, "/Disabled");
                if (!disabledDir.exists()) {
                    disabledDir.mkdirs();
                }
                if ((disabledName = new File(disabledDir, hatName + ".tc2")).exists()) {
                    disabledName.delete();
                }
                if (file.renameTo(disabledName)) break;
                Hats.console("Failed to disable hat: " + file.getName());
                break;
            }
            if (file.delete()) break;
            Hats.console("Failed to delete hat: " + file.getName());
            break;
        }
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory() || file.getName().equalsIgnoreCase("Disabled")) continue;
            HatHandler.deleteHat(file, hatName, disable);
        }
    }

    public static boolean isInFavourites(String hatName) {
        return HatHandler.isInCategory(hatName, "Favourites");
    }

    public static boolean isInCategory(String hatName, String category) {
        if (category.equalsIgnoreCase("Contributors")) {
            return false;
        }
        ArrayList<String> favs = categories.get(category);
        if (favs != null) {
            for (String s : favs) {
                if (!s.equalsIgnoreCase(hatName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isContributor(String hatName) {
        ArrayList<String> favs = categories.get("Contributors");
        if (favs != null) {
            for (String s : favs) {
                if (!s.equalsIgnoreCase(hatName)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addToCategory(String hatName, String category) {
        ArrayList<String> favs = categories.get(category);
        if (favs != null) {
            boolean contained = false;
            for (int i = favs.size() - 1; i >= 0; --i) {
                String fav = favs.get(i);
                if (!fav.equalsIgnoreCase(hatName)) continue;
                contained = true;
                break;
            }
            if (!contained) {
                for (Map.Entry<File, String> e : hatNames.entrySet()) {
                    if (!hatName.toLowerCase().equalsIgnoreCase(e.getValue())) continue;
                    File favFile = new File(hatsFolder, "/" + category + "/" + hatName + ".tc2");
                    FileInputStream inStream = null;
                    OutputStream outStream = null;
                    try {
                        int length;
                        inStream = new FileInputStream(e.getKey());
                        outStream = new FileOutputStream(favFile);
                        byte[] buffer = new byte[1024];
                        while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                            outStream.write(buffer, 0, length);
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    try {
                        if (inStream != null) {
                            ((InputStream)inStream).close();
                        }
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                    favs.add(hatName);
                    break;
                }
            }
        }
    }

    public static void removeFromCategory(String hatName, String category) {
        ArrayList<String> favs = categories.get(category);
        if (favs != null) {
            for (int i = favs.size() - 1; i >= 0; --i) {
                String fav = favs.get(i);
                if (!fav.equalsIgnoreCase(hatName)) continue;
                File favFile = new File(hatsFolder, "/" + category + "/" + hatName + ".tc2");
                File hatFile = new File(hatsFolder, hatName + ".tc2");
                if (!hatFile.exists()) {
                    favFile.renameTo(hatFile);
                } else {
                    favFile.delete();
                }
                favs.remove(i);
                break;
            }
        }
    }

    public static void requestHat(String name, EntityPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketRequestHat(name), (EntityPlayer)player);
        } else {
            PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketRequestHat(name));
        }
    }

    public static void receiveHatData(String hatName, byte packets, byte packetNumber, byte[] byteValues, EntityPlayer player, boolean isServer) {
        if (Hats.config.getInt("allowReceivingOfHats") != 1) {
            return;
        }
        try {
            ArrayList<Object> byteArray = hatParts.get(hatName);
            if (byteArray == null) {
                byteArray = new ArrayList();
                hatParts.put(hatName, byteArray);
                for (int i = 0; i < packets; ++i) {
                    byteArray.add(new byte[0]);
                }
            }
            byteArray.set(packetNumber, byteValues);
            boolean hasAllInfo = true;
            for (int i = 0; i < byteArray.size(); ++i) {
                byte[] byteList = (byte[])byteArray.get(i);
                if (byteList.length != 0) continue;
                hasAllInfo = false;
            }
            if (hasAllInfo) {
                boolean newHat;
                File file = new File(hatsFolder, hatName + ".tc2");
                if (file.exists()) {
                    Hats.console(file.getName() + " already exists! Will not save.");
                    return;
                }
                FileOutputStream fis = new FileOutputStream(file);
                for (int i = 0; i < byteArray.size(); ++i) {
                    byte[] byteList = (byte[])byteArray.get(i);
                    fis.write(byteList);
                }
                fis.close();
                String md5 = MD5Checksum.getMD5Checksum((File)file);
                boolean bl = newHat = checksums.get(md5) == null;
                if (HatHandler.readHatFromFile(file)) {
                    if (isServer) {
                        ArrayList<String> queuedLists = queuedHats.get(hatName.toLowerCase());
                        if (queuedLists != null) {
                            queuedHats.remove(hatName);
                            for (String name : queuedLists) {
                                EntityPlayerMP player1 = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(name);
                                if (player1 == null) continue;
                                HatHandler.sendHat(hatName, (EntityPlayer)player1);
                            }
                        }
                        if (newHat) {
                            Hats.console("Received " + file.getName() + " from " + player.func_70005_c_());
                        } else {
                            Hats.proxy.remap(file.getName().substring(0, file.getName().length() - 4).toLowerCase(), checksums.get(md5).getName().substring(0, checksums.get(md5).getName().length() - 4).toLowerCase());
                            Hats.console("Deleting " + file.getName() + " from " + (isServer ? player.func_70005_c_() : "server") + "! Duplicate hat file with different name. Remapping hat to original file.", true);
                            if (!file.delete()) {
                                Hats.console("Failed to delete file! We're doomed!", true);
                            }
                            HatInfo info = CommonProxy.playerWornHats.get(player.func_70005_c_());
                            CommonProxy.playerWornHats.put(player.func_70005_c_(), new HatInfo(checksums.get(md5).getName().substring(0, checksums.get(md5).getName().length() - 4).toLowerCase(), info.colourR, info.colourG, info.colourB, info.alpha));
                        }
                        Hats.proxy.sendPlayerListOfWornHats(player, false);
                    } else {
                        CommonProxy.tickHandlerClient.requestedHats.remove(hatName.toLowerCase());
                        if (newHat) {
                            Hats.console("Received " + file.getName() + " from server.");
                            HatHandler.repopulateHatsList();
                        } else {
                            Hats.proxy.remap(file.getName().substring(0, file.getName().length() - 4).toLowerCase(), checksums.get(md5).getName().substring(0, checksums.get(md5).getName().length() - 4).toLowerCase());
                            Hats.console("Deleting " + file.getName() + " from " + (isServer ? player.func_70005_c_() : "server") + "! Duplicate hat file with different name. Remapping hat to original file.", true);
                            if (!file.delete()) {
                                Hats.console("Failed to delete file! We're doomed!", true);
                            }
                        }
                    }
                } else {
                    Hats.console("Deleting " + file.getName() + " from " + (isServer ? player.func_70005_c_() : "server") + "! SafeLoad is on, and the Model file contains files which are not XML or PNG files.", true);
                    if (!file.delete()) {
                        Hats.console("Failed to delete file! We're doomed!", true);
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void sendHat(String hatName, EntityPlayer player) {
        if (Hats.config.getInt("allowSendingOfHats") != 1) {
            return;
        }
        File file = null;
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            if (!e.getValue().equalsIgnoreCase(hatName)) continue;
            file = e.getKey();
        }
        if (file != null) {
            int fileSize = (int)file.length();
            if (fileSize > 250000) {
                Hats.console("Unable to send " + file.getName() + ". It is above the size limit!", true);
                return;
            }
            if (fileSize == 0) {
                Hats.console("Unable to send " + file.getName() + ". The file is empty!", true);
                return;
            }
            Hats.console("Sending " + file.getName() + " to " + (player == null ? "the server" : player.func_70005_c_()));
            try {
                FileInputStream fis = new FileInputStream(file);
                String hatFullName = file.getName().substring(0, file.getName().length() - 4);
                int packetsToSend = (int)Math.ceil((float)fileSize / 32000.0f);
                int packetCount = 0;
                while (fileSize > 0) {
                    byte[] fileBytes = new byte[fileSize > 32000 ? 32000 : fileSize];
                    fis.read(fileBytes);
                    if (player != null) {
                        PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketHatFragment(hatFullName, packetsToSend, packetCount, fileSize > 32000 ? 32000 : fileSize, fileBytes), (EntityPlayer)player);
                    } else {
                        PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketHatFragment(hatFullName, packetsToSend, packetCount, fileSize > 32000 ? 32000 : fileSize, fileBytes));
                    }
                    ++packetCount;
                    fileSize -= 32000;
                }
                fis.close();
            }
            catch (IOException e) {}
        } else if (player != null) {
            ArrayList<String> queuedLists = queuedHats.get(hatName.toLowerCase());
            if (queuedLists == null) {
                queuedLists = new ArrayList();
                queuedHats.put(hatName, queuedLists);
            }
            queuedLists.add(player.func_70005_c_());
        }
    }

    public static boolean hasHat(String name) {
        if (name.equalsIgnoreCase("")) {
            return true;
        }
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            if (!e.getValue().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String getHatStartingWith(String name) {
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            if (!e.getValue().toLowerCase().startsWith(name.toLowerCase())) continue;
            return e.getValue();
        }
        return name;
    }

    public static ArrayList<String> getAllHats() {
        ArrayList<String> hatList = new ArrayList<String>();
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            hatList.add(e.getValue());
        }
        return hatList;
    }

    public static ArrayList<String> getHatsWithWeightedContributors() {
        ArrayList<String> hatList = new ArrayList<String>();
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            if (e.getValue().startsWith("(C)".toLowerCase()) && rand.nextFloat() > (float)Hats.config.getInt("useRandomContributorHats") / 100.0f) continue;
            hatList.add(e.getValue());
        }
        return hatList;
    }

    public static EnumChatFormatting getHatRarityColour(String hat) {
        if (Hats.config.getSessionInt("hatGenerationSeed") == 0) {
            return EnumChatFormatting.WHITE;
        }
        float rarity = HatHandler.getHatRarity(hat);
        if (rarity < 0.14285715f) {
            return EnumChatFormatting.AQUA;
        }
        if (rarity < 0.2857143f) {
            return EnumChatFormatting.GOLD;
        }
        if (rarity < 0.42857143f) {
            return EnumChatFormatting.YELLOW;
        }
        if (rarity < 0.5714286f) {
            return EnumChatFormatting.LIGHT_PURPLE;
        }
        if (rarity < 0.71428573f) {
            return EnumChatFormatting.BLUE;
        }
        if (rarity < 0.85714287f) {
            return EnumChatFormatting.DARK_GREEN;
        }
        if (rarity < 1.0f) {
            return EnumChatFormatting.WHITE;
        }
        return EnumChatFormatting.WHITE;
    }

    public static float getHatRarity(String hatName) {
        hatGen.setSeed(Hats.config.getSessionInt("hatGenerationSeed"));
        int hash = Math.abs(hatName.toLowerCase().hashCode());
        int rand = hatGen.nextInt(hash);
        return (float)rand / (float)hash;
    }

    public static HatInfo getRandomHatFromList(ArrayList<String> list, boolean withRarity) {
        if (list.size() == 1) {
            return new HatInfo(list.get(0), 255, 255, 255, 255);
        }
        if (list.size() == 0) {
            return new HatInfo();
        }
        if (withRarity) {
            HatInfo hat = null;
            int triesPerPass = 500;
            float randAmp = 1.0f;
            int tries = 0;
            while (hat == null) {
                String hatName = list.get(rand.nextInt(list.size()));
                float rarity = HatHandler.getHatRarity(hatName);
                if (rand.nextFloat() < rarity * randAmp) {
                    hat = new HatInfo(hatName, 255, 255, 255, 255);
                }
                if (++tries < 500) continue;
                tries = 0;
                randAmp += 0.05f;
            }
            return hat;
        }
        return new HatInfo(list.get(rand.nextInt(list.size())), 255, 255, 255, 255);
    }

    public static ArrayList<String> getAllHatNamesAsList() {
        ArrayList<String> hatNameList = new ArrayList<String>();
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            String name = e.getKey().getName().substring(0, e.getKey().getName().length() - 4);
            hatNameList.add(name);
        }
        Collections.sort(hatNameList);
        return hatNameList;
    }

    public static String[] getAllHatsAsArray() {
        ArrayList<String> hatNameList = HatHandler.getAllHatNamesAsList();
        String[] hatNameArray = new String[hatNameList.size()];
        hatNameList.toArray(hatNameArray);
        return hatNameArray;
    }

    public static void unlockHat(EntityPlayer player, String hat) {
        if (player == null || hat == null || hat.isEmpty()) {
            return;
        }
        TreeMap<String, Integer> hats = CommonProxy.tickHandlerServer.getPlayerHatsList(player.func_70005_c_());
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            String name = e.getKey().getName().substring(0, e.getKey().getName().length() - 4);
            if (!name.equalsIgnoreCase(hat)) continue;
            Integer hatCount = hats.get(name);
            if (hatCount == null) {
                hatCount = 1;
                hats.put(name, hatCount);
            } else {
                hats.put(name, hatCount + 1);
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Integer> e1 : hats.entrySet()) {
                String hatName = HatHandler.getNameForHat(e1.getKey());
                sb.append(hatName);
                if (e1.getValue() > 1) {
                    sb.append(">" + e1.getValue());
                }
                sb.append(":");
            }
            NBTTagCompound persistentTag = player.getEntityData().func_74775_l("PlayerPersisted");
            persistentTag.func_74778_a("Hats_unlocked", sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString());
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
            PacketHandler.sendToPlayer(Hats.channels, (AbstractPacket)new PacketString(0, name), (EntityPlayer)player);
            break;
        }
    }

    public static String getNameForHat(String hat) {
        for (Map.Entry<File, String> e2 : hatNames.entrySet()) {
            if (!e2.getValue().equalsIgnoreCase(hat)) continue;
            return e2.getKey().getName().substring(0, e2.getKey().getName().length() - 4);
        }
        return hat;
    }

    @SideOnly(value=Side.CLIENT)
    public static void reloadAndOpenGui() {
        HatHandler.repopulateHatsList();
        if (Hats.config.getSessionInt("playerHatsMode") == 3) {
            PacketHandler.sendToServer(Hats.channels, (AbstractPacket)new PacketPing(0, false));
        } else if (Hats.config.getSessionInt("playerHatsMode") != 2) {
            Hats.proxy.openHatsGui();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void repopulateHatsList() {
        CommonProxy.tickHandlerClient.availableHats.clear();
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            CommonProxy.tickHandlerClient.availableHats.put(e.getKey().getName().substring(0, e.getKey().getName().length() - 4), 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void populateHatsList(String s) {
        String[] split;
        CommonProxy.tickHandlerClient.availableHats.clear();
        for (String hatNameWithCount : split = s.split(":")) {
            String[] hatNameAndCount = hatNameWithCount.split(">");
            if (hatNameAndCount[0].trim().isEmpty()) continue;
            try {
                CommonProxy.tickHandlerClient.availableHats.put(hatNameAndCount[0].trim(), hatNameAndCount.length == 1 ? 1 : Integer.parseInt(hatNameAndCount[1]));
            }
            catch (Exception e) {
                CommonProxy.tickHandlerClient.availableHats.put(hatNameAndCount[0].trim(), 1);
            }
        }
        for (Map.Entry<File, String> e : hatNames.entrySet()) {
            String name = e.getKey().getName().substring(0, e.getKey().getName().length() - 4);
            if (!HatHandler.isPlayersContributorHat(name, Minecraft.func_71410_x().field_71439_g.func_70005_c_())) continue;
            CommonProxy.tickHandlerClient.availableHats.put(name, CommonProxy.tickHandlerClient.availableHats.get(name) == null ? 1 : CommonProxy.tickHandlerClient.availableHats.get(name) + 1);
        }
        CommonProxy.tickHandlerClient.serverHats = new HashMap<String, Integer>(CommonProxy.tickHandlerClient.availableHats);
    }

    public static boolean isPlayersContributorHat(String hatName, String playerName) {
        return hatName.toLowerCase().startsWith("(c)") && hatName.toLowerCase().contains(playerName.toLowerCase()) || hatName.equalsIgnoreCase("(C) iChun") && playerName.equalsIgnoreCase("ohaiiChun") || hatName.equalsIgnoreCase("(C) Mr. Haz") && playerName.equalsIgnoreCase("damien95") || hatName.equalsIgnoreCase("(C) Fridgeboy") && playerName.equalsIgnoreCase("lacsap32");
    }

    public static boolean canMobHat(EntityLivingBase ent) {
        return !ent.field_70128_L && !ent.func_70631_g_() && HatHandler.getRenderHelper(ent.getClass()) != null && HatHandler.getRenderHelper(ent.getClass()).canWearHat(ent);
    }

    public static RenderOnEntityHelper getRenderHelper(Class clz) {
        if (EntityLivingBase.class.isAssignableFrom(clz) && clz != EntityLivingBase.class) {
            RenderOnEntityHelper helper = CommonProxy.renderHelpers.get(clz);
            if (helper == null) {
                return HatHandler.getRenderHelper(clz.getSuperclass());
            }
            return helper;
        }
        return null;
    }

    public static boolean isMobSpawner(Class clz, Class callingClz) {
        if (!TileEntity.class.isAssignableFrom(clz)) {
            return false;
        }
        Boolean bool = mobSpawners.get(clz);
        if (bool == null) {
            try {
                Field[] fields;
                for (Field field : fields = clz.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!MobSpawnerBaseLogic.class.isAssignableFrom(field.getType())) continue;
                    bool = true;
                    mobSpawnerLogic.put(callingClz, field);
                    mobSpawners.put(callingClz, bool);
                    break;
                }
                if (bool == null) {
                    bool = clz.getSuperclass() == TileEntity.class ? false : HatHandler.isMobSpawner(clz.getSuperclass(), callingClz);
                    mobSpawners.put(callingClz, bool);
                }
            }
            catch (Exception e) {
                bool = false;
                mobSpawners.put(callingClz, bool);
            }
        }
        return bool;
    }

    public static MobSpawnerBaseLogic getMobSpawnerLogic(Class<? extends TileEntity> clz, TileEntity instance) {
        try {
            Field field = mobSpawnerLogic.get(clz);
            if (field != null) {
                field.setAccessible(true);
                Object obj = field.get(instance);
                if (obj instanceof MobSpawnerBaseLogic) {
                    return (MobSpawnerBaseLogic)obj;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        queuedHats = new HashMap();
        hatParts = new HashMap();
        hatNames = new HashMap();
        checksums = new HashMap();
        categories = new HashMap();
        rand = new Random();
        hatGen = new Random();
        mobSpawners = new HashMap();
        mobSpawnerLogic = new HashMap();
    }
}

