/*
 * Decompiled with CFR 0.152.
 */
package hats.common.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import hats.common.Hats;
import hats.common.core.HatHandler;
import ichun.common.core.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSession
extends AbstractPacket {
    public int hatMode;
    public int randSeed;
    public boolean hasVisited;
    public String serverHat;
    public String currentKing;
    public String playerHats;

    public PacketSession() {
    }

    public PacketSession(int serverHatMode, int randSeed, boolean visited, String serverHat, String currentKing, String hats) {
        this.hatMode = serverHatMode;
        this.randSeed = randSeed;
        this.hasVisited = visited;
        this.serverHat = serverHat;
        this.currentKing = currentKing;
        this.playerHats = hats;
    }

    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeInt(this.hatMode);
        buffer.writeInt(this.randSeed);
        buffer.writeBoolean(this.hasVisited);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.serverHat);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.currentKing);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerHats);
    }

    public void readFrom(ByteBuf buffer, Side side) {
        Hats.config.updateSession("serverHasMod", (Object)1);
        Hats.config.updateSession("playerHatsMode", (Object)buffer.readInt());
        Hats.config.updateSession("hatGenerationSeed", (Object)buffer.readInt());
        Hats.config.updateSession("hasVisited", (Object)(buffer.readBoolean() ? 1 : 0));
        Hats.config.updateSession("lockedHat", (Object)ByteBufUtils.readUTF8String((ByteBuf)buffer));
        Hats.config.updateSession("currentKing", (Object)ByteBufUtils.readUTF8String((ByteBuf)buffer));
        Hats.config.updateSession("showJoinMessage", (Object)(Hats.config.getSessionInt("playerHatsMode") >= 4 && Hats.config.getSessionInt("hasVisited") == 0 ? 1 : 0));
        String availHats = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (Hats.config.getSessionInt("playerHatsMode") >= 4) {
            HatHandler.populateHatsList(availHats);
        }
    }

    public void execute(Side side, EntityPlayer player) {
    }
}

