/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import com.google.common.collect.Lists;
import java.util.List;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.KeyHandler;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.VanillaMapping;
import mods.betterfoliage.client.WindTracker;
import mods.betterfoliage.client.event.PostLoadModelDefinitionsEvent;
import mods.betterfoliage.client.render.impl.EntityFXFallingLeaves;
import mods.betterfoliage.client.render.impl.EntityFXRisingSoul;
import mods.betterfoliage.client.render.impl.RenderBlockBetterAlgae;
import mods.betterfoliage.client.render.impl.RenderBlockBetterCactus;
import mods.betterfoliage.client.render.impl.RenderBlockBetterCoral;
import mods.betterfoliage.client.render.impl.RenderBlockBetterGrass;
import mods.betterfoliage.client.render.impl.RenderBlockBetterLeaves;
import mods.betterfoliage.client.render.impl.RenderBlockBetterLilypad;
import mods.betterfoliage.client.render.impl.RenderBlockBetterMycelium;
import mods.betterfoliage.client.render.impl.RenderBlockBetterNetherrack;
import mods.betterfoliage.client.render.impl.RenderBlockBetterReed;
import mods.betterfoliage.client.resource.LeafGenerator;
import mods.betterfoliage.client.resource.LeafTextureRegistry;
import mods.betterfoliage.client.resource.ReedGenerator;
import mods.betterfoliage.client.resource.ShortGrassGenerator;
import mods.betterfoliage.client.resource.SoulParticleTextures;
import mods.betterfoliage.common.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BetterFoliageClient {
    public static ResourceLocation missingTexture = new ResourceLocation("betterfoliage", "textures/blocks/missing_leaf.png");
    public static List<BFAbstractRenderer> renderers = Lists.newLinkedList();
    public static LeafTextureRegistry leafRegistry = new LeafTextureRegistry();
    public static LeafGenerator leafGenerator = new LeafGenerator();
    public static SoulParticleTextures soulParticles = new SoulParticleTextures();
    public static WindTracker wind = new WindTracker();

    public static void postInit() {
        FMLCommonHandler.instance().bus().register((Object)new KeyHandler());
        FMLCommonHandler.instance().bus().register((Object)new Config());
        ShadersModIntegration.init();
        BetterFoliage.log.info("Registering renderers");
        BetterFoliageClient.registerRenderer(new RenderBlockBetterLeaves());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterGrass());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterCactus());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterMycelium());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterLilypad());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterAlgae());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterCoral());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterReed());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterNetherrack());
        MinecraftForge.EVENT_BUS.register((Object)wind);
        FMLCommonHandler.instance().bus().register((Object)wind);
        MinecraftForge.EVENT_BUS.register((Object)Config.leaves);
        MinecraftForge.EVENT_BUS.register((Object)Config.crops);
        MinecraftForge.EVENT_BUS.register((Object)Config.dirt);
        MinecraftForge.EVENT_BUS.register((Object)Config.grass);
        BetterFoliage.log.info("Registering texture generators");
        MinecraftForge.EVENT_BUS.register((Object)soulParticles);
        MinecraftForge.EVENT_BUS.register((Object)leafGenerator);
        MinecraftForge.EVENT_BUS.register((Object)leafRegistry);
        BetterFoliageClient.leafRegistry.leafMappings.add(new VanillaMapping("minecraft:models/block/leaves", "all"));
        MinecraftForge.EVENT_BUS.register((Object)new ReedGenerator("bf_reed_bottom", missingTexture, true));
        MinecraftForge.EVENT_BUS.register((Object)new ReedGenerator("bf_reed_top", missingTexture, false));
        MinecraftForge.EVENT_BUS.register((Object)new ShortGrassGenerator("bf_shortgrass", missingTexture, false));
        MinecraftForge.EVENT_BUS.register((Object)new ShortGrassGenerator("bf_shortgrass_snow", missingTexture, true));
    }

    public static void onRandomDisplayTick(World world, IBlockState blockState, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (Config.soulFXEnabled && block == Blocks.field_150425_aM && Math.random() < Config.soulFXChance) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityFXRisingSoul(world, pos));
            return;
        }
        if (Config.leafFXEnabled && Config.leaves.matchesID(block) && world.func_175623_d(pos.func_177982_a(0, -1, 0)) && Math.random() < Config.leafFXChance) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityFXFallingLeaves(world, blockState, pos));
            return;
        }
    }

    public static boolean canRenderBlockInLayer(Block block, EnumWorldBlockLayer layer) {
        if (block.canRenderInLayer(layer)) {
            return true;
        }
        if (block == Blocks.field_150354_m && Config.coralEnabled) {
            return layer == EnumWorldBlockLayer.CUTOUT_MIPPED;
        }
        if (block == Blocks.field_150391_bh && Config.grassEnabled) {
            return layer == EnumWorldBlockLayer.CUTOUT_MIPPED;
        }
        if (block == Blocks.field_150434_aF && Config.cactusEnabled) {
            return layer == EnumWorldBlockLayer.CUTOUT_MIPPED;
        }
        if (block == Blocks.field_150392_bi && Config.lilypadEnabled) {
            return layer == EnumWorldBlockLayer.CUTOUT_MIPPED;
        }
        if (block == Blocks.field_150424_aL && Config.netherrackEnabled) {
            return layer == EnumWorldBlockLayer.CUTOUT_MIPPED;
        }
        if (Config.dirt.matchesID(block) && (Config.algaeEnabled || Config.reedEnabled)) {
            return layer == EnumWorldBlockLayer.CUTOUT_MIPPED;
        }
        return false;
    }

    public static boolean renderWorldBlock(BlockRendererDispatcher dispatcher, IBlockState state, BlockPos pos, IBlockAccess blockAccess, WorldRenderer worldRenderer, EnumWorldBlockLayer layer) {
        boolean result;
        boolean bl = result = state.func_177230_c().canRenderInLayer(layer) ? dispatcher.func_175018_a(state, pos, blockAccess, worldRenderer) : false;
        if (layer == EnumWorldBlockLayer.CUTOUT_MIPPED) {
            boolean useAO = Minecraft.func_71379_u() && state.func_177230_c().func_149750_m() == 0;
            for (BFAbstractRenderer renderer : renderers) {
                result |= renderer.renderFeatureForBlock(blockAccess, state, pos, worldRenderer, useAO);
            }
        }
        return result;
    }

    public static void onAfterLoadModelDefinitions(ModelLoader loader) {
        MinecraftForge.EVENT_BUS.post((Event)new PostLoadModelDefinitionsEvent(loader));
    }

    public static void registerRenderer(BFAbstractRenderer renderer) {
        MinecraftForge.EVENT_BUS.register((Object)renderer);
        renderers.add(renderer);
    }
}

