/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import mods.betterfoliage.common.util.Double3;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PerturbationSource {
    public Double3[] pRot = new Double3[64];
    public double[] pRand = new double[64];

    public PerturbationSource() {
        ArrayList<Double3> perturbs = new ArrayList<Double3>(64);
        for (int idx = 0; idx < 64; ++idx) {
            double angle = (double)idx * Math.PI * 2.0 / 64.0;
            perturbs.add(new Double3(Math.cos(angle), Math.random() * 2.0 - 1.0, Math.sin(angle)));
            this.pRand[idx] = Math.random();
        }
        Collections.shuffle(perturbs);
        Iterator iter = perturbs.iterator();
        for (int idx = 0; idx < 64; ++idx) {
            this.pRot[idx] = (Double3)iter.next();
        }
    }

    public Double3 getCylinderXZY(double radius, double halfHeight, int variation) {
        return this.pRot[variation & 0x3F].scaleAxes(radius, halfHeight, radius);
    }

    public Double3 getCircleXZ(double radius, int variation) {
        return this.getCylinderXZY(radius, 0.0, variation);
    }

    public double getRange(double min, double max, int variation) {
        return min + (max - min) * this.pRand[variation & 0x3F];
    }
}

