/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.common.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShadersModIntegration {
    private static boolean hasShadersMod = false;
    private static int tallGrassEntityData;
    private static int leavesEntityData;
    private static Method pushEntity;
    private static Method popEntity;
    private static Field vertexBuilder;

    private ShadersModIntegration() {
    }

    public static void init() {
        tallGrassEntityData = Block.field_149771_c.func_148757_b((Object)Blocks.field_150329_H) & 0xFFFF | Blocks.field_150329_H.func_149645_b() << 16;
        leavesEntityData = Block.field_149771_c.func_148757_b((Object)Blocks.field_150362_t) & 0xFFFF | Blocks.field_150362_t.func_149645_b() << 16;
        try {
            Class<?> classSVertexBuilder = Class.forName("shadersmod.client.SVertexBuilder");
            pushEntity = classSVertexBuilder.getMethod("pushEntity", Long.TYPE);
            popEntity = classSVertexBuilder.getMethod("popEntity", WorldRenderer.class);
            vertexBuilder = WorldRenderer.class.getDeclaredField("sVertexBuilder");
            hasShadersMod = true;
            BetterFoliage.log.info("ShadersMod found, integration enabled");
        }
        catch (Exception e) {
            BetterFoliage.log.info("ShadersMod not found, integration disabled");
        }
    }

    public static void startGrassQuads(WorldRenderer renderer) {
        if (!hasShadersMod) {
            return;
        }
        ShadersModIntegration.pushEntity(renderer, tallGrassEntityData);
    }

    public static void startLeavesQuads(WorldRenderer renderer) {
        if (!hasShadersMod) {
            return;
        }
        ShadersModIntegration.pushEntity(renderer, leavesEntityData);
    }

    public static void finish(WorldRenderer renderer) {
        if (!hasShadersMod) {
            return;
        }
        ShadersModIntegration.popEntity(renderer);
    }

    public static int getBlockIdOverride(int original, IBlockState blockState) {
        if (Config.leaves.matchesID(original & 0xFFFF)) {
            return leavesEntityData;
        }
        if (Config.crops.matchesID(original & 0xFFFF)) {
            return tallGrassEntityData;
        }
        return original;
    }

    public static boolean isSpecialTexture(ResourceLocation resource) {
        return resource.func_110623_a().toLowerCase().endsWith("_n.png") || resource.func_110623_a().toLowerCase().endsWith("_s.png");
    }

    protected static void pushEntity(WorldRenderer renderer, long data) {
        try {
            Object builder = vertexBuilder.get(renderer);
            pushEntity.invoke(builder, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void popEntity(WorldRenderer renderer) {
        try {
            popEntity.invoke(null, renderer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

