/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mods.betterfoliage.client.IModelTextureMapping;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VanillaMapping
implements IModelTextureMapping {
    public String modelName;
    public String textureName;
    private static Class<?> classVanillaModelWrapper;
    private static Field fieldVanillaModelBlock;
    private static Class<?> classWeightedPartWrapper;
    private static Field fieldWeightedPartModel;
    private static Class<?> classWeightedRandomModel;
    private static Field fieldWeightedRandomModels;

    public VanillaMapping(String modelName, String textureName) {
        this.modelName = modelName;
        this.textureName = textureName;
    }

    @Nullable
    public String apply(@Nullable IModel input) {
        Iterator<ModelBlock> i$ = VanillaMapping.getVanillaModelsDFS(input).iterator();
        while (i$.hasNext()) {
            String texture;
            ModelBlock vanillaModel;
            ModelBlock current = vanillaModel = i$.next();
            boolean modelMatch = false;
            while (current != null) {
                if (current.field_178317_b.equals(this.modelName)) {
                    modelMatch = true;
                }
                current = current.field_178315_d;
            }
            if (!modelMatch || (texture = vanillaModel.func_178308_c(this.textureName)) == null) continue;
            return texture;
        }
        return null;
    }

    protected static Iterable<ModelBlock> getVanillaModelsDFS(IModel model) {
        LinkedList result = Lists.newLinkedList();
        VanillaMapping.addAllChildren(result, model);
        return result;
    }

    protected static void addAllChildren(Collection<ModelBlock> list, IModel model) {
        try {
            if (classVanillaModelWrapper.isInstance(model)) {
                ModelBlock block = (ModelBlock)fieldVanillaModelBlock.get(model);
                list.add(block);
            }
            if (classWeightedPartWrapper.isInstance(model)) {
                IModel wrappedModel = (IModel)fieldWeightedPartModel.get(model);
                VanillaMapping.addAllChildren(list, wrappedModel);
            }
            if (classWeightedRandomModel.isInstance(model)) {
                Iterable models = (Iterable)fieldWeightedRandomModels.get(model);
                for (IModel wrappedModel : models) {
                    VanillaMapping.addAllChildren(list, wrappedModel);
                }
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    static {
        try {
            classVanillaModelWrapper = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
            fieldVanillaModelBlock = classVanillaModelWrapper.getDeclaredField("model");
            fieldVanillaModelBlock.setAccessible(true);
            classWeightedPartWrapper = Class.forName("net.minecraftforge.client.model.ModelLoader$WeightedPartWrapper");
            fieldWeightedPartModel = classWeightedPartWrapper.getDeclaredField("model");
            fieldWeightedPartModel.setAccessible(true);
            classWeightedRandomModel = Class.forName("net.minecraftforge.client.model.ModelLoader$WeightedRandomModel");
            fieldWeightedRandomModels = classWeightedRandomModel.getDeclaredField("models");
            fieldWeightedRandomModels.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

