/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.gui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.List;
import mods.betterfoliage.client.gui.SelectListConfigEntry;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.BiomeUtils;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BiomeListConfigEntry
extends SelectListConfigEntry<BiomeGenBase> {
    public String tooltipKey = "";
    public List<BiomeGenBase> defaultSelected = null;

    public BiomeListConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
        super(owningScreen, owningEntryList, configElement);
    }

    @Override
    protected List<BiomeGenBase> getBaseSet(String name) {
        return BiomeUtils.getAllBiomes();
    }

    @Override
    protected List<BiomeGenBase> getDefaultSelected(String name) {
        if (this.defaultSelected == null) {
            Predicate<BiomeGenBase> defaultFilter = Predicates.alwaysFalse();
            if (this.configElement.getName().equals("reedBiomeList")) {
                defaultFilter = Config.reedBiomeDefaults;
                this.tooltipKey = "betterfoliage.reeds.biomeSelectTooltip";
            }
            if (this.configElement.getName().equals("algaeBiomeList")) {
                defaultFilter = Config.algaeBiomeDefaults;
                this.tooltipKey = "betterfoliage.algae.biomeSelectTooltip";
            }
            if (this.configElement.getName().equals("coralBiomeList")) {
                defaultFilter = Config.coralBiomeDefaults;
                this.tooltipKey = "betterfoliage.coral.biomeSelectTooltip";
            }
            this.defaultSelected = Lists.newArrayList((Iterable)Collections2.filter(BiomeUtils.getAllBiomes(), defaultFilter));
        }
        return this.defaultSelected;
    }

    @Override
    protected int getItemId(BiomeGenBase item) {
        return item.field_76756_M;
    }

    @Override
    protected String getItemName(BiomeGenBase item) {
        return item.field_76791_y;
    }

    @Override
    protected String getTooltipLangKey(String name) {
        return this.tooltipKey;
    }
}

