/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render;

import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockShadingData {
    public BFAbstractRenderer.BFAmbientOcclusionFace[] aoFaces = new BFAbstractRenderer.BFAmbientOcclusionFace[6];
    public boolean[] isTranslucent = new boolean[6];
    public int[] mixedBrightness = new int[6];
    public boolean useAO;
    public static int[][][] vertexIndexToFaces = new int[6][6][6];

    public BlockShadingData(BFAbstractRenderer renderer) {
        for (int j = 0; j < EnumFacing.values().length; ++j) {
            this.aoFaces[j] = new BFAbstractRenderer.BFAmbientOcclusionFace(renderer);
        }
    }

    public void update(IBlockAccess blockAccessIn, Block blockIn, BlockPos blockPosIn, boolean useAO) {
        this.useAO = useAO;
        if (useAO) {
            BitSet bitset = new BitSet(3);
            bitset.set(0);
            for (EnumFacing facing : EnumFacing.values()) {
                this.aoFaces[facing.ordinal()].func_178204_a(blockAccessIn, blockIn, blockPosIn, facing, null, bitset);
                this.isTranslucent[facing.ordinal()] = blockAccessIn.func_180495_p(blockPosIn).func_177230_c().func_149751_l();
            }
        } else {
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos facingPos = blockPosIn.func_177972_a(facing);
                this.mixedBrightness[facing.ordinal()] = blockAccessIn.func_180495_p(facingPos).func_177230_c().func_176207_c(blockAccessIn, facingPos);
                this.isTranslucent[facing.ordinal()] = blockAccessIn.func_180495_p(blockPosIn).func_177230_c().func_149751_l();
            }
        }
    }

    public int getBrightness(EnumFacing primary, EnumFacing secondary, EnumFacing tertiary, boolean useMax) {
        if (this.useAO) {
            int pri = this.aoFaces[primary.ordinal()].field_178207_c[vertexIndexToFaces[primary.ordinal()][secondary.ordinal()][tertiary.ordinal()]];
            if (!useMax) {
                return pri;
            }
            int sec = this.aoFaces[secondary.ordinal()].field_178207_c[vertexIndexToFaces[secondary.ordinal()][primary.ordinal()][tertiary.ordinal()]];
            int ter = this.aoFaces[tertiary.ordinal()].field_178207_c[vertexIndexToFaces[tertiary.ordinal()][primary.ordinal()][secondary.ordinal()]];
            return pri > sec && pri > ter ? pri : (sec > ter ? sec : ter);
        }
        int pri = this.mixedBrightness[primary.ordinal()];
        if (!useMax) {
            return pri;
        }
        int sec = this.mixedBrightness[secondary.ordinal()];
        int ter = this.mixedBrightness[tertiary.ordinal()];
        return pri > sec && pri > ter ? pri : (sec > ter ? sec : ter);
    }

    public float getColorMultiplier(EnumFacing primary, EnumFacing secondary, EnumFacing tertiary, boolean useMax) {
        float pri = this.aoFaces[primary.ordinal()].field_178206_b[vertexIndexToFaces[primary.ordinal()][secondary.ordinal()][tertiary.ordinal()]];
        if (!useMax) {
            return pri;
        }
        float sec = this.aoFaces[secondary.ordinal()].field_178206_b[vertexIndexToFaces[secondary.ordinal()][primary.ordinal()][tertiary.ordinal()]];
        float ter = this.aoFaces[tertiary.ordinal()].field_178206_b[vertexIndexToFaces[tertiary.ordinal()][primary.ordinal()][secondary.ordinal()]];
        return pri > sec && pri > ter ? pri : (sec > ter ? sec : ter);
    }

    static {
        for (EnumFacing face : EnumFacing.values()) {
            for (EnumFacing axis1 : EnumFacing.values()) {
                for (EnumFacing axis2 : EnumFacing.values()) {
                    BlockShadingData.vertexIndexToFaces[face.ordinal()][axis1.ordinal()][axis2.ordinal()] = BFAbstractRenderer.getAoIndexForFaces(face, axis1, axis2);
                }
            }
        }
    }
}

