/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import java.awt.Color;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.resource.LeafTextureRegistry;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityFXFallingLeaves
extends EntityFX {
    protected static double[] cos = new double[64];
    protected static double[] sin = new double[64];
    public static float rotationFlipChance;
    public static float biomeBrightnessMultiplier;
    public boolean wasOnGround = false;
    public boolean isMirrored;
    public int particleRotation = 0;
    public boolean rotationPositive = true;

    public EntityFXFallingLeaves(World world, IBlockState blockState, BlockPos pos) {
        super(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.field_70547_e = MathHelper.func_76128_c((double)((0.6 + 0.4 * this.field_70146_Z.nextDouble()) * Config.leafFXLifetime * 20.0));
        this.isMirrored = (this.field_70146_Z.nextInt() & 1) == 1;
        this.field_70181_x = -Config.leafFXSpeed;
        this.particleRotation = this.field_70146_Z.nextInt(64);
        this.field_70544_f = (float)Config.leafFXSize;
        LeafTextureRegistry.LeafInfo leafInfo = BetterFoliageClient.leafRegistry.leafInfoMap.get(blockState);
        if (leafInfo == null || leafInfo.particleType == null) {
            return;
        }
        this.field_70550_a = BetterFoliageClient.leafRegistry.particleTextures.get(leafInfo.particleType).get(this.field_70146_Z.nextInt(1024));
        Color4 blockColor = Color4.fromARGB(blockState.func_177230_c().func_180662_a((IBlockAccess)world, pos, 0)).opaque();
        this.calculateParticleColor(leafInfo.averageColor, blockColor);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70544_f = (float)Config.leafFXSize;
        if (this.field_70146_Z.nextFloat() < rotationFlipChance) {
            boolean bl = this.rotationPositive = !this.rotationPositive;
        }
        if (this.field_70546_d > this.field_70547_e - 20) {
            this.field_82339_as = 0.05f * (float)(this.field_70547_e - this.field_70546_d);
        }
        if (this.field_70122_E || this.wasOnGround) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70179_y = 0.0;
            if (!this.wasOnGround) {
                this.field_70546_d = Math.max(this.field_70546_d, this.field_70547_e - 20);
            }
            this.wasOnGround = true;
        } else {
            this.field_70159_w = (BetterFoliageClient.wind.currentX + cos[this.particleRotation] * Config.leafFXPerturb) * Config.leafFXSpeed;
            this.field_70179_y = (BetterFoliageClient.wind.currentZ + sin[this.particleRotation] * Config.leafFXPerturb) * Config.leafFXSpeed;
            this.field_70181_x = -Config.leafFXSpeed;
            this.particleRotation = this.particleRotation + (this.rotationPositive ? 1 : -1) & 0x3F;
        }
    }

    public void func_180434_a(WorldRenderer renderer, Entity entity, float partialTickTime, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        float minU = this.isMirrored ? this.field_70550_a.func_94209_e() : this.field_70550_a.func_94212_f();
        float maxU = this.isMirrored ? this.field_70550_a.func_94212_f() : this.field_70550_a.func_94209_e();
        float minV = this.field_70550_a.func_94206_g();
        float maxV = this.field_70550_a.func_94210_h();
        float scale = 0.1f * this.field_70544_f;
        Double3 center = new Double3(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTickTime - field_70556_an, this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTickTime - field_70554_ao, this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTickTime - field_70555_ap);
        Double3 vec1 = new Double3(rotX + rotXY, rotZ, rotYZ + rotXZ).scale(scale);
        Double3 vec2 = new Double3(rotX - rotXY, -rotZ, rotYZ - rotXZ).scale(scale);
        Double3 vec1Rot = vec1.scale(cos[this.particleRotation]).add(vec2.scale(sin[this.particleRotation]));
        Double3 vec2Rot = vec1.scale(-sin[this.particleRotation]).add(vec2.scale(cos[this.particleRotation]));
        renderer.func_178960_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        this.addVertex(renderer, center.sub(vec1Rot), maxU, maxV);
        this.addVertex(renderer, center.sub(vec2Rot), maxU, minV);
        this.addVertex(renderer, center.add(vec1Rot), minU, minV);
        this.addVertex(renderer, center.add(vec2Rot), minU, maxV);
    }

    protected void addVertex(WorldRenderer renderer, Double3 coord, double u, double v) {
        renderer.func_178985_a(coord.x, coord.y, coord.z, u, v);
    }

    public void calculateParticleColor(Color4 textureAvgColor, Color4 blockColor) {
        float[] hsbTexture = Color.RGBtoHSB(textureAvgColor.R, textureAvgColor.G, textureAvgColor.B, null);
        float[] hsbBlock = Color.RGBtoHSB(blockColor.R, blockColor.G, blockColor.B, null);
        float weightTex = hsbTexture[1] / (hsbTexture[1] + hsbBlock[1]);
        float weightBlock = 1.0f - weightTex;
        float h = weightTex * hsbTexture[0] + weightBlock * hsbBlock[0];
        float s = weightTex * hsbTexture[1] + weightBlock * hsbBlock[1];
        float b = weightTex * hsbTexture[2] + weightBlock * hsbBlock[2] * biomeBrightnessMultiplier;
        int particleColor = Color.HSBtoRGB(h, s, b);
        this.field_70551_j = (float)(particleColor & 0xFF) / 256.0f;
        this.field_70553_i = (float)(particleColor >> 8 & 0xFF) / 256.0f;
        this.field_70552_h = (float)(particleColor >> 16 & 0xFF) / 256.0f;
    }

    public int func_70537_b() {
        return 1;
    }

    static {
        for (int idx = 0; idx < 64; ++idx) {
            EntityFXFallingLeaves.cos[idx] = Math.cos(0.09817477042468103 * (double)idx);
            EntityFXFallingLeaves.sin[idx] = Math.sin(0.09817477042468103 * (double)idx);
        }
        rotationFlipChance = 0.05f;
        biomeBrightnessMultiplier = 0.5f;
    }
}

