/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.Iterator;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityFXRisingSoul
extends EntityFX {
    protected static double[] cos = new double[64];
    protected static double[] sin = new double[64];
    public int initialPhase;
    public Deque<Double3> particleTrail = Lists.newLinkedList();

    public EntityFXRisingSoul(World world, BlockPos pos) {
        super(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
        this.field_70181_x = 0.1f;
        this.field_70545_g = 0.0f;
        this.field_70550_a = BetterFoliageClient.soulParticles.soulHeadIcons.get(this.field_70146_Z.nextInt(256));
        this.field_70547_e = MathHelper.func_76128_c((double)((0.6 + 0.4 * this.field_70146_Z.nextDouble()) * Config.soulFXLifetime * 20.0));
        this.initialPhase = this.field_70146_Z.nextInt(64);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int phase = (this.initialPhase + this.field_70546_d) % 64;
        this.field_70181_x = 0.1f;
        this.field_70159_w = cos[phase] * Config.soulFXPerturb;
        this.field_70179_y = sin[phase] * Config.soulFXPerturb;
        this.particleTrail.addFirst(new Double3(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        while (this.particleTrail.size() > Config.soulFXTrailLength) {
            this.particleTrail.removeLast();
        }
    }

    public void func_180434_a(WorldRenderer renderer, Entity entity, float partialTickTime, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        Double3 vec1 = new Double3(rotX + rotXY, rotZ, rotYZ + rotXZ);
        Double3 vec2 = new Double3(rotX - rotXY, -rotZ, rotYZ - rotXZ);
        Iterator<Double3> iter = this.particleTrail.iterator();
        TextureAtlasSprite renderIcon = this.field_70550_a;
        double scale = Config.soulFXHeadSize * 0.25;
        float alpha = (float)Config.soulFXOpacity;
        if (this.field_70546_d > this.field_70547_e - 40) {
            alpha *= (float)(this.field_70547_e - this.field_70546_d) / 40.0f;
        }
        int idx = 0;
        if (iter.hasNext()) {
            Double3 previous = iter.next();
            while (iter.hasNext()) {
                Double3 current = previous;
                previous = iter.next();
                if (idx++ % Config.soulFXTrailDensity == 0) {
                    renderer.func_178960_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha);
                    this.renderParticleQuad(renderer, partialTickTime, current, previous, vec1, vec2, renderIcon, scale);
                }
                if (idx == 1) {
                    scale = Config.soulFXTrailSize * 0.25;
                    renderIcon = BetterFoliageClient.soulParticles.soulTrackIcon;
                }
                scale *= Config.soulFXSizeDecay;
                alpha = (float)((double)alpha * Config.soulFXOpacityDecay);
            }
        }
    }

    protected void renderParticleQuad(WorldRenderer renderer, float partialTickTime, Double3 currentPos, Double3 previousPos, Double3 vec1, Double3 vec2, TextureAtlasSprite texture, double scale) {
        float minU = texture.func_94209_e();
        float maxU = texture.func_94212_f();
        float minV = texture.func_94206_g();
        float maxV = texture.func_94210_h();
        Double3 center = new Double3(previousPos.x + (currentPos.x - previousPos.x) * (double)partialTickTime - field_70556_an, previousPos.y + (currentPos.y - previousPos.y) * (double)partialTickTime - field_70554_ao, previousPos.z + (currentPos.z - previousPos.z) * (double)partialTickTime - field_70555_ap);
        this.addVertex(renderer, center.sub(vec1.scale(scale)), maxU, maxV);
        this.addVertex(renderer, center.sub(vec2.scale(scale)), maxU, minV);
        this.addVertex(renderer, center.add(vec1.scale(scale)), minU, minV);
        this.addVertex(renderer, center.add(vec2.scale(scale)), minU, maxV);
    }

    protected void addVertex(WorldRenderer renderer, Double3 coord, double u, double v) {
        renderer.func_178985_a(coord.x, coord.y, coord.z, u, v);
    }

    public int func_70537_b() {
        return 1;
    }

    static {
        for (int idx = 0; idx < 64; ++idx) {
            EntityFXRisingSoul.cos[idx] = Math.cos(0.09817477042468103 * (double)idx);
            EntityFXRisingSoul.sin[idx] = Math.sin(0.09817477042468103 * (double)idx);
        }
    }
}

