/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import java.util.Random;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.TextureSet;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.FaceCrossedQuads;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterAlgae
extends BFAbstractRenderer {
    public static int seedOffset = 1;
    public TextureSet algaeIcons = new TextureSet("bettergrassandleaves", "blocks/better_algae_%d");
    public NoiseGeneratorSimplex noise;

    @Override
    public boolean renderFeatureForBlock(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, WorldRenderer worldRenderer, boolean useAO) {
        if (!Config.algaeEnabled) {
            return false;
        }
        if (!Config.dirt.matchesID(blockState.func_177230_c())) {
            return false;
        }
        if (!Config.algaeBiomeList.contains(blockAccess.func_180494_b((BlockPos)pos).field_76756_M)) {
            return false;
        }
        if (blockAccess.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() != Material.field_151586_h) {
            return false;
        }
        if (blockAccess.func_180495_p(pos.func_177981_b(2)).func_177230_c().func_149688_o() != Material.field_151586_h) {
            return false;
        }
        int terrainVariation = MathHelper.func_76128_c((double)((this.noise.func_151605_a((double)pos.func_177958_n(), (double)pos.func_177952_p()) + 1.0) * 32.0));
        if (terrainVariation >= Config.algaePopulation) {
            return false;
        }
        int offsetVariation = this.getSemiRandomFromPos(pos, 0);
        int textureVariation = this.getSemiRandomFromPos(pos, 1);
        double halfSize = 0.5 * Config.algaeSize;
        double halfHeight = 0.5 * this.random.getRange(Config.algaeHeightMin, Config.algaeHeightMax, offsetVariation);
        Double3 offset = this.random.getCircleXZ(Config.algaeHOffset, offsetVariation);
        Double3 faceCenter = new Double3(pos).add(0.5, 1.0, 0.5);
        ShadersModIntegration.startGrassQuads(worldRenderer);
        this.shadingData.update(blockAccess, blockState.func_177230_c(), pos, useAO);
        FaceCrossedQuads algae = FaceCrossedQuads.createTranslated(faceCenter, EnumFacing.UP, offset, halfSize, halfHeight);
        algae.setTexture(this.algaeIcons.get(textureVariation), 0).setBrightness(this.shadingData).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
        ShadersModIntegration.finish(worldRenderer);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        this.algaeIcons.registerSprites(event.map);
        BetterFoliage.log.info(String.format("Found %d algae textures", this.algaeIcons.numLoaded));
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        this.noise = new NoiseGeneratorSimplex(new Random(event.world.func_72912_H().func_76063_b() + (long)seedOffset));
    }
}

