/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import java.util.Random;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.render.TextureSet;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.FaceCrossedQuads;
import mods.betterfoliage.client.render.impl.primitives.SimpleOrientedQuad;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderBlockBetterCoral
extends BFAbstractRenderer {
    public static int seedOffset = 2;
    public TextureSet coralCrustIcons = new TextureSet("bettergrassandleaves", "blocks/better_crust_%d");
    public TextureSet coralCrossIcons = new TextureSet("bettergrassandleaves", "blocks/better_coral_%d");
    public NoiseGeneratorSimplex noise;

    @Override
    public boolean renderFeatureForBlock(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, WorldRenderer worldRenderer, boolean useAO) {
        if (!Config.coralEnabled) {
            return false;
        }
        if (blockState.func_177230_c() != Blocks.field_150354_m) {
            return false;
        }
        if (!Config.coralBiomeList.contains(blockAccess.func_180494_b((BlockPos)pos).field_76756_M)) {
            return false;
        }
        int terrainVariation = MathHelper.func_76128_c((double)((this.noise.func_151605_a((double)pos.func_177958_n() * 0.1, (double)pos.func_177952_p() * 0.1) + 1.0) * 32.0));
        if (terrainVariation >= Config.coralPopulation) {
            return false;
        }
        Double3 blockCenter = new Double3(pos).add(0.5, 0.5, 0.5);
        double offset = this.random.getRange(0.0, Config.coralVOffset, this.getSemiRandomFromPos(pos, 1));
        int textureVariation = this.getSemiRandomFromPos(pos, 2);
        double halfSize = Config.coralSize * 0.5;
        double halfCrustSize = Config.coralCrustSize * 0.5;
        this.shadingData.update(blockAccess, blockState.func_177230_c(), pos, useAO);
        for (EnumFacing face : EnumFacing.values()) {
            if (blockAccess.func_180495_p(pos.func_177972_a(face)).func_177230_c().func_149688_o() != Material.field_151586_h || !Config.coralShallowWater && blockAccess.func_175623_d(pos.func_177972_a(face).func_177984_a()) || textureVariation >= Config.coralChance) continue;
            SimpleOrientedQuad coralCrust = SimpleOrientedQuad.create(blockCenter.add(new Double3(face).scale(0.5 + offset)), face, halfCrustSize);
            FaceCrossedQuads coral = FaceCrossedQuads.createTranslated(blockCenter.add(new Double3(face).scale(0.5)), face, this.random.getCircleXZ(Config.coralHOffset, textureVariation), halfSize, halfSize);
            coralCrust.setTexture(this.coralCrustIcons.get(textureVariation + face.ordinal()), textureVariation + face.ordinal()).setBrightness(this.shadingData).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
            coral.setTexture(this.coralCrossIcons.get(textureVariation + face.ordinal()), 0).setBrightness(this.shadingData).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
        }
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        this.coralCrustIcons.registerSprites(event.map);
        this.coralCrossIcons.registerSprites(event.map);
        BetterFoliage.log.info(String.format("Found %d coral crust textures", this.coralCrustIcons.numLoaded));
        BetterFoliage.log.info(String.format("Found %d coral textures", this.coralCrossIcons.numLoaded));
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        this.noise = new NoiseGeneratorSimplex(new Random(event.world.func_72912_H().func_76063_b() + (long)seedOffset));
    }
}

