/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.TextureSet;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.FaceCrossedQuads;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterGrass
extends BFAbstractRenderer {
    public TextureSet grassIcons = new TextureSet("bettergrassandleaves", "blocks/better_grass_long_%d");
    public TextureSet snowGrassIcons = new TextureSet("bettergrassandleaves", "blocks/better_grass_snowed_%d");
    public TextureAtlasSprite grassGenIcon;
    public TextureAtlasSprite snowGrassGenIcon;
    public static Color4 snowColor = Color4.fromARGB(255, 200, 200, 200);

    @Override
    public boolean renderFeatureForBlock(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, WorldRenderer worldRenderer, boolean useAO) {
        if (!Config.grassEnabled) {
            return false;
        }
        if (!Config.grass.matchesID(blockState.func_177230_c())) {
            return false;
        }
        if (blockAccess.func_180495_p(pos.func_177984_a()).func_177230_c().func_149662_c()) {
            return false;
        }
        boolean isSnowTop = blockAccess.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c().func_149688_o() == Material.field_151597_y;
        int offsetVariation = this.getSemiRandomFromPos(pos, 0);
        int textureVariation = this.getSemiRandomFromPos(pos, 1);
        double halfSize = 0.5 * Config.grassSize;
        double halfHeight = 0.5 * this.random.getRange(Config.grassHeightMin, Config.grassHeightMax, offsetVariation);
        Double3 offset = this.random.getCircleXZ(Config.grassHOffset, offsetVariation);
        Color4 blockColor = Color4.fromARGB(blockState.func_177230_c().func_180662_a(blockAccess, pos, 0)).opaque();
        Double3 faceCenter = new Double3(pos).add(0.5, 1.0, 0.5);
        ShadersModIntegration.startGrassQuads(worldRenderer);
        this.shadingData.update(blockAccess, blockState.func_177230_c(), pos, useAO);
        FaceCrossedQuads grass = FaceCrossedQuads.createTranslated(faceCenter.add(0.0, isSnowTop ? 0.1 : 0.0, 0.0), EnumFacing.UP, offset, halfSize, halfHeight);
        grass.setTexture(Config.grassUseGenerated ? (isSnowTop ? this.snowGrassGenIcon : this.grassGenIcon) : (isSnowTop ? this.snowGrassIcons : this.grassIcons).get(textureVariation), 0);
        grass.setBrightness(this.shadingData).setColor(this.shadingData, isSnowTop ? snowColor : blockColor).render(worldRenderer);
        ShadersModIntegration.finish(worldRenderer);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        this.grassIcons.registerSprites(event.map);
        this.snowGrassIcons.registerSprites(event.map);
        this.grassGenIcon = event.map.func_174942_a(new ResourceLocation("bf_shortgrass:minecraft:blocks/tallgrass"));
        this.snowGrassGenIcon = event.map.func_174942_a(new ResourceLocation("bf_shortgrass_snow:minecraft:blocks/tallgrass"));
        BetterFoliage.log.info(String.format("Found %d short grass textures", this.grassIcons.numLoaded));
        BetterFoliage.log.info(String.format("Found %d snowy grass textures", this.snowGrassIcons.numLoaded));
    }
}

