/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.TextureSet;
import mods.betterfoliage.client.render.impl.primitives.BlockCrossedQuads;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.resource.LeafTextureRegistry;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterLeaves
extends BFAbstractRenderer {
    public TextureSet snowedLeavesIcons = new TextureSet("bettergrassandleaves", "blocks/better_leaves_snowed_%d");

    @Override
    public boolean renderFeatureForBlock(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, WorldRenderer worldRenderer, boolean useAO) {
        boolean isSnowTop;
        if (!Config.leavesEnabled) {
            return false;
        }
        if (!Config.leaves.matchesID(blockState.func_177230_c())) {
            return false;
        }
        LeafTextureRegistry.LeafInfo leafInfo = BetterFoliageClient.leafRegistry.leafInfoMap.get(blockState);
        if (leafInfo == null || leafInfo.roundLeafTexture == null) {
            return false;
        }
        boolean[] isAir = new boolean[6];
        boolean hasAir = false;
        for (int i = 0; i < 6; ++i) {
            isAir[i] = blockAccess.func_175623_d(pos.func_177972_a(EnumFacing.values()[i]));
            hasAir |= isAir[i];
        }
        boolean bl = isSnowTop = blockAccess.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151597_y;
        if (!hasAir && !isSnowTop) {
            return false;
        }
        int offsetVariation = this.getSemiRandomFromPos(pos, 0);
        int uvVariation = this.getSemiRandomFromPos(pos, 1);
        double halfSize = 0.5 * Config.leavesSize;
        Color4 blockColor = Color4.fromARGB(blockState.func_177230_c().func_180662_a(blockAccess, pos, 0)).opaque().multiply(0.75f);
        Double3 blockCenter = new Double3(pos).add(0.5, 0.5, 0.5);
        Double3 offset1 = this.random.getCylinderXZY(Config.leavesHOffset, Config.leavesVOffset, offsetVariation);
        Double3 offset2 = this.random.getCylinderXZY(Config.leavesHOffset, Config.leavesVOffset, offsetVariation + 1);
        ShadersModIntegration.startLeavesQuads(worldRenderer);
        this.shadingData.update(blockAccess, blockState.func_177230_c(), pos, useAO);
        BlockCrossedQuads roundLeaves = Config.leavesSkew ? BlockCrossedQuads.createSkewed(blockCenter, offset1, offset2, halfSize) : BlockCrossedQuads.createTranslated(blockCenter, offset1, halfSize);
        roundLeaves.setTexture(leafInfo.roundLeafTexture, uvVariation).setBrightness(this.shadingData).setColor(this.shadingData, blockColor).render(worldRenderer);
        if (isSnowTop) {
            roundLeaves.setTexture(this.snowedLeavesIcons.get(uvVariation), 0).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
        }
        ShadersModIntegration.finish(worldRenderer);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        this.snowedLeavesIcons.registerSprites(event.map);
        BetterFoliage.log.info(String.format("Found %d snowed leaves textures", this.snowedLeavesIcons.numLoaded));
    }
}

