/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.TextureSet;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.FaceCrossedQuads;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterLilypad
extends BFAbstractRenderer {
    public TextureSet lilypadFlowers = new TextureSet("bettergrassandleaves", "blocks/better_lilypad_flower_%d");
    public TextureSet lilypadRoots = new TextureSet("bettergrassandleaves", "blocks/better_lilypad_roots_%d");

    @Override
    public boolean renderFeatureForBlock(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, WorldRenderer worldRenderer, boolean useAO) {
        if (!Config.lilypadEnabled) {
            return false;
        }
        if (blockState.func_177230_c() != Blocks.field_150392_bi) {
            return false;
        }
        int chanceVariation = this.getSemiRandomFromPos(pos, 0);
        int iconVariation = this.getSemiRandomFromPos(pos, 1);
        int offsetVariation = this.getSemiRandomFromPos(pos, 2);
        double halfSize = 0.2;
        double halfHeight = 0.3;
        Double3 offset = this.random.getCircleXZ(Config.lilypadHOffset, offsetVariation);
        Double3 faceCenter = new Double3(pos).add(0.5, 0.0, 0.5);
        ShadersModIntegration.startGrassQuads(worldRenderer);
        this.shadingData.update(blockAccess, blockState.func_177230_c(), pos, useAO);
        FaceCrossedQuads roots = FaceCrossedQuads.createTranslated(faceCenter.add(0.0, 0.015, 0.0), EnumFacing.DOWN, offset, halfSize, halfHeight);
        roots.setTexture(this.lilypadRoots.get(iconVariation), 2).setBrightness(this.shadingData).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
        ShadersModIntegration.finish(worldRenderer);
        if (chanceVariation < Config.lilypadChance) {
            FaceCrossedQuads flower = FaceCrossedQuads.createTranslated(faceCenter.add(0.0, 0.02, 0.0), EnumFacing.UP, offset, halfSize, halfHeight);
            flower.setTexture(this.lilypadFlowers.get(iconVariation), 0).setBrightness(this.shadingData).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
        }
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        this.lilypadFlowers.registerSprites(event.map);
        this.lilypadRoots.registerSprites(event.map);
        BetterFoliage.log.info(String.format("Found %d lilypad flower textures", this.lilypadFlowers.numLoaded));
        BetterFoliage.log.info(String.format("Found %d lilypad root textures", this.lilypadRoots.numLoaded));
    }
}

