/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.TextureSet;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.FaceCrossedQuads;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterMycelium
extends BFAbstractRenderer {
    public TextureSet myceliumIcons = new TextureSet("bettergrassandleaves", "blocks/better_mycel_%d");

    @Override
    public boolean renderFeatureForBlock(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, WorldRenderer worldRenderer, boolean useAO) {
        if (!Config.grassEnabled) {
            return false;
        }
        if (blockAccess.func_180495_p(pos.func_177984_a()).func_177230_c().func_149662_c()) {
            return false;
        }
        if (blockState.func_177230_c() != Blocks.field_150391_bh) {
            return false;
        }
        boolean isSnowTop = blockAccess.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c().func_149688_o() == Material.field_151597_y;
        int offsetVariation = this.getSemiRandomFromPos(pos, 0);
        int textureVariation = this.getSemiRandomFromPos(pos, 1);
        double halfSize = 0.5 * Config.grassSize;
        double halfHeight = 0.5 * this.random.getRange(Config.grassHeightMin, Config.grassHeightMax, offsetVariation);
        Double3 offset = this.random.getCircleXZ(Config.grassHOffset, offsetVariation);
        Double3 faceCenter = new Double3(pos).add(0.5, 1.0, 0.5);
        ShadersModIntegration.startGrassQuads(worldRenderer);
        this.shadingData.update(blockAccess, blockState.func_177230_c(), pos, useAO);
        FaceCrossedQuads mycelium = FaceCrossedQuads.createTranslated(faceCenter.add(0.0, isSnowTop ? 0.1 : 0.0, 0.0), EnumFacing.UP, offset, halfSize, halfHeight);
        mycelium.setTexture(this.myceliumIcons.get(textureVariation), 0).setBrightness(this.shadingData).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
        ShadersModIntegration.finish(worldRenderer);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        this.myceliumIcons.registerSprites(event.map);
        BetterFoliage.log.info(String.format("Found %d mycelium textures", this.myceliumIcons.numLoaded));
    }
}

