/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.render.TextureSet;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.FaceCrossedQuads;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BFAbstractRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterNetherrack
extends BFAbstractRenderer {
    public TextureSet netherrackVineIcons = new TextureSet("bettergrassandleaves", "blocks/better_netherrack_%d");

    @Override
    public boolean renderFeatureForBlock(IBlockAccess blockAccess, IBlockState blockState, BlockPos pos, WorldRenderer worldRenderer, boolean useAO) {
        if (!Config.netherrackEnabled) {
            return false;
        }
        if (blockState.func_177230_c() != Blocks.field_150424_aL) {
            return false;
        }
        if (blockAccess.func_180495_p(pos.func_177977_b()).func_177230_c().func_149662_c()) {
            return false;
        }
        int offsetVariation = this.getSemiRandomFromPos(pos, 0);
        int textureVariation = this.getSemiRandomFromPos(pos, 1);
        double halfSize = 0.5 * Config.netherrackSize;
        double halfHeight = 0.5 * this.random.getRange(Config.netherrackHeightMin, Config.netherrackHeightMax, offsetVariation);
        Double3 offset = this.random.getCircleXZ(Config.netherrackHOffset, offsetVariation);
        Double3 faceCenter = new Double3(pos).add(0.5, 0.0, 0.5);
        this.shadingData.update(blockAccess, blockState.func_177230_c(), pos, useAO);
        FaceCrossedQuads vines = FaceCrossedQuads.createTranslated(faceCenter, EnumFacing.DOWN, offset, halfSize, halfHeight);
        vines.setTexture(this.netherrackVineIcons.get(textureVariation), 2).setBrightness(this.shadingData).setColor(this.shadingData, Color4.opaqueWhite).render(worldRenderer);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        this.netherrackVineIcons.registerSprites(event.map);
        BetterFoliage.log.info(String.format("Found %d netherrack vine textures", this.netherrackVineIcons.numLoaded));
    }
}

