/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl.primitives;

import mods.betterfoliage.client.render.BlockShadingData;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.DynamicQuad;
import mods.betterfoliage.client.render.impl.primitives.IQuadCollection;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockCrossedQuads
implements IQuadCollection {
    public static boolean useMax = true;
    public DynamicQuad NE;
    public DynamicQuad NW;
    public DynamicQuad SE;
    public DynamicQuad SW;

    private BlockCrossedQuads() {
    }

    public static BlockCrossedQuads createSkewed(Double3 blockCenter, Double3 perturb1, Double3 perturb2, double halfSize) {
        BlockCrossedQuads result = new BlockCrossedQuads();
        Double3 horz1 = new Double3(halfSize, 0.0, halfSize).add(perturb1);
        Double3 horz2 = new Double3(halfSize, 0.0, -halfSize).add(perturb2);
        Double3 vert = new Double3(0.0, halfSize * 1.41, 0.0);
        result.SW = DynamicQuad.createParallelogram(blockCenter, horz1, vert);
        result.NE = DynamicQuad.createParallelogram(blockCenter, horz1.inverse(), vert);
        result.SE = DynamicQuad.createParallelogram(blockCenter, horz2, vert);
        result.NW = DynamicQuad.createParallelogram(blockCenter, horz2.inverse(), vert);
        return result;
    }

    public static BlockCrossedQuads createTranslated(Double3 blockCenter, Double3 perturb, double halfSize) {
        BlockCrossedQuads result = new BlockCrossedQuads();
        Double3 drawCenter = blockCenter.add(perturb);
        Double3 horz1 = new Double3(halfSize, 0.0, halfSize);
        Double3 horz2 = new Double3(halfSize, 0.0, -halfSize);
        Double3 vert = new Double3(0.0, halfSize * 1.41, 0.0);
        result.SW = DynamicQuad.createParallelogram(drawCenter, horz1, vert);
        result.NE = DynamicQuad.createParallelogram(drawCenter, horz1.inverse(), vert);
        result.SE = DynamicQuad.createParallelogram(drawCenter, horz2, vert);
        result.NW = DynamicQuad.createParallelogram(drawCenter, horz2.inverse(), vert);
        return result;
    }

    @Override
    public IQuadCollection setTexture(TextureAtlasSprite texture, int uvRot) {
        this.NE.setTexture(texture, uvRot);
        this.NW.setTexture(texture, uvRot);
        this.SE.setTexture(texture, uvRot);
        this.SW.setTexture(texture, uvRot);
        return this;
    }

    @Override
    public IQuadCollection setBrightness(BlockShadingData shadingData) {
        this.NE.setBrightness(shadingData.getBrightness(EnumFacing.NORTH, EnumFacing.UP, EnumFacing.WEST, useMax), shadingData.getBrightness(EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH, useMax), shadingData.getBrightness(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH, useMax), shadingData.getBrightness(EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.WEST, useMax));
        this.NW.setBrightness(shadingData.getBrightness(EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH, useMax), shadingData.getBrightness(EnumFacing.NORTH, EnumFacing.UP, EnumFacing.EAST, useMax), shadingData.getBrightness(EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.EAST, useMax), shadingData.getBrightness(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.SOUTH, useMax));
        this.SE.setBrightness(shadingData.getBrightness(EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH, useMax), shadingData.getBrightness(EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.WEST, useMax), shadingData.getBrightness(EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.WEST, useMax), shadingData.getBrightness(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.NORTH, useMax));
        this.SW.setBrightness(shadingData.getBrightness(EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.EAST, useMax), shadingData.getBrightness(EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH, useMax), shadingData.getBrightness(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH, useMax), shadingData.getBrightness(EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.EAST, useMax));
        return this;
    }

    @Override
    public IQuadCollection setColor(BlockShadingData shadingData, Color4 color) {
        if (shadingData.useAO) {
            this.NE.setColor(color.multiply(shadingData.getColorMultiplier(EnumFacing.NORTH, EnumFacing.UP, EnumFacing.WEST, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.WEST, useMax)));
            this.NW.setColor(color.multiply(shadingData.getColorMultiplier(EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.NORTH, EnumFacing.UP, EnumFacing.EAST, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.EAST, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.SOUTH, useMax)));
            this.SE.setColor(color.multiply(shadingData.getColorMultiplier(EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.WEST, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.WEST, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.NORTH, useMax)));
            this.SW.setColor(color.multiply(shadingData.getColorMultiplier(EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.EAST, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH, useMax)), color.multiply(shadingData.getColorMultiplier(EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.EAST, useMax)));
        } else {
            this.NE.setColor(color);
            this.NW.setColor(color);
            this.SE.setColor(color);
            this.SW.setColor(color);
        }
        return this;
    }

    @Override
    public void render(WorldRenderer renderer) {
        this.NE.render(renderer);
        this.NW.render(renderer);
        this.SE.render(renderer);
        this.SW.render(renderer);
    }
}

