/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl.primitives;

import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Color4 {
    public static final Color4 opaqueWhite = Color4.fromARGB(255, 255, 255, 255);
    public static final Color4 transparentWhite = Color4.fromARGB(0, 255, 255, 255);
    public static final Color4 opaqueBlack = Color4.fromARGB(255, 0, 0, 0);
    public int R;
    public int G;
    public int B;
    public int A;

    private Color4() {
    }

    private Color4(Color4 orig) {
        this.A = orig.A;
        this.R = orig.R;
        this.G = orig.G;
        this.B = orig.B;
    }

    public static Color4 fromARGB(int color) {
        Color4 result = new Color4();
        result.A = color >> 24 & 0xFF;
        result.R = color >> 16 & 0xFF;
        result.G = color >> 8 & 0xFF;
        result.B = color & 0xFF;
        return result;
    }

    public static Color4 fromARGB(int A, int R, int G, int B) {
        Color4 result = new Color4();
        result.A = A;
        result.R = R;
        result.G = G;
        result.B = B;
        return result;
    }

    public Color4 opaque() {
        Color4 result = new Color4(this);
        result.A = 255;
        return result;
    }

    public Color4 multiply(float scale) {
        int scaleI = MathHelper.func_76141_d((float)(scale * 255.0f));
        return Color4.fromARGB(this.A, this.R * scaleI / 255, this.G * scaleI / 255, this.B * scaleI / 255);
    }
}

