/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl.primitives;

import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DynamicQuad {
    protected static EnumFacing[] faceTop = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP};
    protected static EnumFacing[] faceRight = new EnumFacing[]{EnumFacing.WEST, EnumFacing.WEST, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.NORTH};
    protected static double[] uValues = new double[]{0.0, 16.0, 16.0, 0.0};
    protected static double[] vValues = new double[]{0.0, 0.0, 16.0, 16.0};
    protected final double[] x = new double[4];
    protected final double[] y = new double[4];
    protected final double[] z = new double[4];
    protected final Color4[] color = new Color4[4];
    protected final int[] brightness = new int[4];
    protected final double[] u = new double[4];
    protected final double[] v = new double[4];

    private DynamicQuad() {
    }

    public static DynamicQuad createParallelogram(Double3 center, Double3 vec1, Double3 vec2) {
        DynamicQuad result = new DynamicQuad();
        result.putRawXYZ(center.add(vec1).add(vec2), 0);
        result.putRawXYZ(center.sub(vec1).add(vec2), 1);
        result.putRawXYZ(center.sub(vec1).sub(vec2), 2);
        result.putRawXYZ(center.add(vec1).sub(vec2), 3);
        return result;
    }

    protected void putRawXYZ(Double3 pos, int index) {
        this.x[index] = pos.x;
        this.y[index] = pos.y;
        this.z[index] = pos.z;
    }

    public DynamicQuad setTexture(TextureAtlasSprite texture, int uvRot) {
        for (int idx = 0; idx < 4; ++idx) {
            this.u[idx] = texture.func_94214_a(uValues[uvRot + idx & 3]);
            this.v[idx] = texture.func_94207_b(vValues[uvRot + idx & 3]);
        }
        return this;
    }

    public DynamicQuad setColor(Color4 color) {
        for (int idx = 0; idx < 4; ++idx) {
            this.color[idx] = color;
        }
        return this;
    }

    public DynamicQuad setColor(Color4 col0, Color4 col1, Color4 col2, Color4 col3) {
        this.color[0] = col0;
        this.color[1] = col1;
        this.color[2] = col2;
        this.color[3] = col3;
        return this;
    }

    public DynamicQuad setBrightness(int brightness) {
        for (int idx = 0; idx < 4; ++idx) {
            this.brightness[idx] = brightness;
        }
        return this;
    }

    public DynamicQuad setBrightness(int br0, int br1, int br2, int br3) {
        this.brightness[0] = br0;
        this.brightness[1] = br1;
        this.brightness[2] = br2;
        this.brightness[3] = br3;
        return this;
    }

    public void render(WorldRenderer renderer) {
        for (int idx = 0; idx < 4; ++idx) {
            Color4 col = this.color[idx];
            renderer.func_178961_b(col.R, col.G, col.B, col.A);
            renderer.func_178963_b(this.brightness[idx]);
            renderer.func_178992_a(this.u[idx], this.v[idx]);
            renderer.func_178984_b(this.x[idx], this.y[idx], this.z[idx]);
        }
    }
}

