/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl.primitives;

import mods.betterfoliage.client.render.BlockShadingData;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.DynamicQuad;
import mods.betterfoliage.client.render.impl.primitives.IQuadCollection;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FaceCrossedQuads
implements IQuadCollection {
    public DynamicQuad TR;
    public DynamicQuad TL;
    public DynamicQuad BL;
    public DynamicQuad BR;
    EnumFacing facing;

    private FaceCrossedQuads() {
    }

    public static FaceCrossedQuads createTranslated(Double3 base, EnumFacing facing, Double3 perturb, double halfWidth, double halfHeight) {
        FaceCrossedQuads result = new FaceCrossedQuads();
        Double3 faceN = new Double3(facing).scale(halfHeight);
        Double3 faceTR = new Double3(DynamicQuad.faceRight[facing.ordinal()]).add(new Double3(DynamicQuad.faceTop[facing.ordinal()])).scale(halfWidth);
        Double3 faceTL = new Double3(DynamicQuad.faceRight[facing.ordinal()]).inverse().add(new Double3(DynamicQuad.faceTop[facing.ordinal()])).scale(halfWidth);
        Double3 drawCenter = base.add(faceN).add(new Double3(DynamicQuad.faceRight[facing.ordinal()]).scale(perturb.x)).add(new Double3(DynamicQuad.faceTop[facing.ordinal()]).scale(perturb.z));
        result.BR = DynamicQuad.createParallelogram(drawCenter, faceTR, faceN);
        result.TL = DynamicQuad.createParallelogram(drawCenter, faceTR.inverse(), faceN);
        result.TR = DynamicQuad.createParallelogram(drawCenter, faceTL, faceN);
        result.BL = DynamicQuad.createParallelogram(drawCenter, faceTL.inverse(), faceN);
        result.facing = facing;
        return result;
    }

    @Override
    public FaceCrossedQuads setTexture(TextureAtlasSprite texture, int uvRot) {
        this.TR.setTexture(texture, uvRot);
        this.TL.setTexture(texture, uvRot);
        this.BL.setTexture(texture, uvRot);
        this.BR.setTexture(texture, uvRot);
        return this;
    }

    @Override
    public FaceCrossedQuads setBrightness(BlockShadingData shadingData) {
        int brTR = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()], false);
        int brTL = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()], false);
        int brBL = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false);
        int brBR = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false);
        this.BR.setBrightness(brTR, brBL, brBL, brTR);
        this.TL.setBrightness(brBL, brTR, brTR, brBL);
        this.TR.setBrightness(brTL, brBR, brBR, brTL);
        this.BL.setBrightness(brBR, brTL, brTL, brBR);
        return this;
    }

    @Override
    public FaceCrossedQuads setColor(BlockShadingData shadingData, Color4 color) {
        if (shadingData.useAO) {
            Color4 colTR = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()], false));
            Color4 colTL = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()], false));
            Color4 colBL = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false));
            Color4 colBR = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false));
            this.BR.setColor(colTR, colBL, colBL, colTR);
            this.TL.setColor(colBL, colTR, colTR, colBL);
            this.TR.setColor(colTL, colBR, colBR, colTL);
            this.BL.setColor(colBR, colTL, colTL, colBR);
        } else {
            this.TR.setColor(color);
            this.TL.setColor(color);
            this.BL.setColor(color);
            this.BR.setColor(color);
        }
        return this;
    }

    @Override
    public void render(WorldRenderer renderer) {
        this.TR.render(renderer);
        this.TL.render(renderer);
        this.BL.render(renderer);
        this.BR.render(renderer);
    }
}

