/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl.primitives;

import mods.betterfoliage.client.render.BlockShadingData;
import mods.betterfoliage.client.render.impl.primitives.Color4;
import mods.betterfoliage.client.render.impl.primitives.DynamicQuad;
import mods.betterfoliage.client.render.impl.primitives.IQuadCollection;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SimpleOrientedQuad
implements IQuadCollection {
    public DynamicQuad quad;
    EnumFacing facing;

    private SimpleOrientedQuad() {
    }

    public static SimpleOrientedQuad create(Double3 center, EnumFacing facing, double halfSize) {
        SimpleOrientedQuad result = new SimpleOrientedQuad();
        Double3 horz1 = new Double3(DynamicQuad.faceRight[facing.ordinal()]).scale(halfSize);
        Double3 horz2 = new Double3(DynamicQuad.faceTop[facing.ordinal()]).scale(halfSize);
        result.quad = DynamicQuad.createParallelogram(center, horz1, horz2);
        result.facing = facing;
        return result;
    }

    @Override
    public IQuadCollection setTexture(TextureAtlasSprite texture, int uvRot) {
        this.quad.setTexture(texture, uvRot);
        return this;
    }

    @Override
    public IQuadCollection setBrightness(BlockShadingData shadingData) {
        int brTR = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()], false);
        int brTL = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()], false);
        int brBL = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false);
        int brBR = shadingData.getBrightness(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false);
        this.quad.setBrightness(brTR, brTL, brBL, brBR);
        return this;
    }

    @Override
    public IQuadCollection setColor(BlockShadingData shadingData, Color4 color) {
        if (shadingData.useAO) {
            Color4 colTR = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()], false));
            Color4 colTL = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()], false));
            Color4 colBL = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()].func_176734_d(), DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false));
            Color4 colBR = color.multiply(shadingData.getColorMultiplier(this.facing, DynamicQuad.faceRight[this.facing.ordinal()], DynamicQuad.faceTop[this.facing.ordinal()].func_176734_d(), false));
            this.quad.setColor(colTR, colTL, colBL, colBR);
        } else {
            this.quad.setColor(color);
        }
        return this;
    }

    @Override
    public void render(WorldRenderer renderer) {
        this.quad.render(renderer);
    }
}

