/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.resource.LeafGeneratorBase;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LeafGenerator
extends LeafGeneratorBase {
    public static String defaultMask = "default";
    public static final String DOMAIN = "bf_leaves";

    public LeafGenerator() {
        super(DOMAIN, "betterfoliage", "textures/blocks/%s/%s", "betterfoliage:textures/blocks/leafmask_%d_%s.png", BetterFoliageClient.missingTexture);
    }

    @Override
    protected BufferedImage generateLeaf(ResourceLocation originalWithDirs) throws IOException, LeafGeneratorBase.TextureGenerationException {
        BufferedImage origFullIcon = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(originalWithDirs).func_110527_b());
        int size = origFullIcon.getWidth();
        int frames = origFullIcon.getHeight() / origFullIcon.getWidth();
        if (origFullIcon.getHeight() % origFullIcon.getWidth() != 0) {
            throw new LeafGeneratorBase.TextureGenerationException();
        }
        BufferedImage genFullIcon = new BufferedImage(size * 2, size * frames * 2, 6);
        Graphics2D genFullGraphics = genFullIcon.createGraphics();
        for (int frame = 0; frame < frames; ++frame) {
            BufferedImage origIcon = origFullIcon.getSubimage(0, size * frame, size, size);
            BufferedImage genIcon = new BufferedImage(size * 2, size * 2, 6);
            Graphics2D genGraphics = genIcon.createGraphics();
            genGraphics.drawImage((Image)origIcon, 0, 0, null);
            genGraphics.drawImage((Image)origIcon, 0, size, null);
            genGraphics.drawImage((Image)origIcon, size, 0, null);
            genGraphics.drawImage((Image)origIcon, size, size, null);
            if (!ShadersModIntegration.isSpecialTexture(originalWithDirs)) {
                BufferedImage maskImage = this.loadLeafMaskImage(defaultMask, size * 2);
                int scale = size * 2 / maskImage.getWidth();
                for (int x = 0; x < genIcon.getWidth(); ++x) {
                    for (int y = 0; y < genIcon.getHeight(); ++y) {
                        long origPixel = (long)genIcon.getRGB(x, y) & 0xFFFFFFFFL;
                        long maskPixel = (long)maskImage.getRGB(x / scale, y / scale) & 0xFF000000L | 0xFFFFFFL;
                        genIcon.setRGB(x, y, (int)(origPixel & maskPixel));
                    }
                }
            }
            genFullGraphics.drawImage((Image)genIcon, 0, size * frame * 2, null);
        }
        return genFullIcon;
    }

    @Override
    @SubscribeEvent
    public void endTextureReload(TextureStitchEvent.Post event) {
        super.endTextureReload(event);
        BetterFoliage.log.info(String.format("Loaded leaf textures: %d generated, %d pre-drawn", this.generatedCounter, this.drawnCounter));
    }
}

