/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.resource.BlockTextureGenerator;
import mods.betterfoliage.client.resource.BufferedImageResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShortGrassGenerator
extends BlockTextureGenerator {
    protected boolean isSnowed = false;
    protected int snowOriginalWeight = 2;
    protected int snowWhiteWeight = 3;

    public ShortGrassGenerator(String domainName, ResourceLocation missingResource, boolean isSnowed) {
        super(domainName, missingResource);
        this.isSnowed = isSnowed;
    }

    public IResource func_110536_a(ResourceLocation resourceLocation) throws IOException {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        ResourceLocation originalNoDirs = this.unwrapResource(resourceLocation);
        ResourceLocation originalWithDirs = new ResourceLocation(originalNoDirs.func_110624_b(), "textures/" + originalNoDirs.func_110623_a());
        BufferedImage origImage = ImageIO.read(resourceManager.func_110536_a(originalWithDirs).func_110527_b());
        BufferedImage result = new BufferedImage(origImage.getWidth(), origImage.getHeight(), 6);
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage((Image)origImage, 0, 3 * origImage.getHeight() / 8, null);
        if (this.isSnowed && !ShadersModIntegration.isSpecialTexture(originalWithDirs)) {
            for (int x = 0; x < result.getWidth(); ++x) {
                for (int y = 0; y < result.getHeight(); ++y) {
                    result.setRGB(x, y, ShortGrassGenerator.blendRGB(result.getRGB(x, y), 0xFFFFFF, 2, 3));
                }
            }
        }
        return new BufferedImageResource(resourceLocation, originalWithDirs, result);
    }
}

