/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.common.config;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mods.betterfoliage.client.gui.AlternateTextBooleanEntry;
import mods.betterfoliage.client.gui.BiomeListConfigEntry;
import mods.betterfoliage.client.gui.NonVerboseArrayEntry;
import mods.betterfoliage.common.util.BiomeUtils;
import mods.betterfoliage.common.util.BlockMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static Configuration rawConfig;
    public static BlockMatcher leaves;
    public static BlockMatcher crops;
    public static BlockMatcher dirt;
    public static BlockMatcher grass;
    public static boolean leavesEnabled;
    public static boolean leavesSkew;
    public static double leavesHOffset;
    public static double leavesVOffset;
    public static double leavesSize;
    public static boolean grassEnabled;
    public static boolean grassUseGenerated;
    public static double grassHOffset;
    public static double grassHeightMin;
    public static double grassHeightMax;
    public static double grassSize;
    public static boolean grassShaderWind;
    public static boolean cactusEnabled;
    public static boolean lilypadEnabled;
    public static double lilypadHOffset;
    public static int lilypadChance;
    public static boolean reedEnabled;
    public static double reedHOffset;
    public static double reedHeightMin;
    public static double reedHeightMax;
    public static int reedPopulation;
    public static boolean reedShaderWind;
    public static boolean algaeEnabled;
    public static double algaeHOffset;
    public static double algaeSize;
    public static double algaeHeightMin;
    public static double algaeHeightMax;
    public static int algaePopulation;
    public static boolean coralEnabled;
    public static boolean coralShallowWater;
    public static int coralPopulation;
    public static int coralChance;
    public static double coralVOffset;
    public static double coralHOffset;
    public static double coralCrustSize;
    public static double coralSize;
    public static boolean leafFXEnabled;
    public static double leafFXSpeed;
    public static double leafFXWindStrength;
    public static double leafFXStormStrength;
    public static double leafFXSize;
    public static double leafFXChance;
    public static double leafFXPerturb;
    public static double leafFXLifetime;
    public static boolean soulFXEnabled;
    public static double soulFXChance;
    public static double soulFXSpeed;
    public static double soulFXPerturb;
    public static double soulFXHeadSize;
    public static double soulFXTrailSize;
    public static double soulFXOpacity;
    public static double soulFXSizeDecay;
    public static double soulFXOpacityDecay;
    public static double soulFXLifetime;
    public static int soulFXTrailLength;
    public static int soulFXTrailDensity;
    public static boolean netherrackEnabled;
    public static double netherrackHOffset;
    public static double netherrackHeightMin;
    public static double netherrackHeightMax;
    public static double netherrackSize;
    public static boolean ctxGrassClassicEnabled;
    public static boolean ctxGrassAggressiveEnabled;
    public static List<Integer> reedBiomeList;
    public static List<Integer> algaeBiomeList;
    public static List<Integer> coralBiomeList;
    public static Predicate<BiomeGenBase> reedBiomeDefaults;
    public static Predicate<BiomeGenBase> algaeBiomeDefaults;
    public static Predicate<BiomeGenBase> coralBiomeDefaults;

    public static void readConfig(File configFile) {
        rawConfig = new Configuration(configFile, true);
        Config.updateValues();
        if (rawConfig.hasChanged()) {
            rawConfig.save();
        }
    }

    public static void updateValues() {
        leavesEnabled = Config.getBoolean(Category.extraLeaves, "enabled", true, "betterfoliage.enabled");
        leavesSkew = Config.getBoolean(Category.extraLeaves, "skewMode", false, "betterfoliage.leavesMode");
        leavesHOffset = Config.getDouble(Category.extraLeaves, "hOffset", 0.2, 0.0, 0.4, "betterfoliage.hOffset");
        leavesVOffset = Config.getDouble(Category.extraLeaves, "vOffset", 0.1, 0.0, 0.4, "betterfoliage.vOffset");
        leavesSize = Config.getDouble(Category.extraLeaves, "size", 1.4, 0.75, 2.5, "betterfoliage.size");
        grassEnabled = Config.getBoolean(Category.shortGrass, "enabled", true, "betterfoliage.enabled");
        grassHOffset = Config.getDouble(Category.shortGrass, "hOffset", 0.2, 0.0, 0.4, "betterfoliage.hOffset");
        grassHeightMin = Config.getDouble(Category.shortGrass, "heightMin", 0.6, 0.1, 2.5, "betterfoliage.minHeight");
        grassHeightMax = Config.getDouble(Category.shortGrass, "heightMax", 0.8, 0.1, 2.5, "betterfoliage.maxHeight");
        grassSize = Config.getDouble(Category.shortGrass, "size", 1.0, 0.5, 1.5, "betterfoliage.size");
        grassUseGenerated = Config.getBoolean(Category.shortGrass, "useGenerated", false, "betterfoliage.shortGrass.useGenerated");
        grassHeightMin = Config.clampDoubleToMax(Category.shortGrass, "heightMin", "heightMax");
        grassShaderWind = Config.getBoolean(Category.shortGrass, "shaderWind", true, "betterfoliage.shaderWind");
        cactusEnabled = Config.getBoolean(Category.cactus, "enabled", true, "betterfoliage.enabled");
        lilypadEnabled = Config.getBoolean(Category.lilypad, "enabled", true, "betterfoliage.enabled");
        lilypadHOffset = Config.getDouble(Category.lilypad, "hOffset", 0.1, 0.0, 0.25, "betterfoliage.hOffset");
        lilypadChance = Config.getInt(Category.lilypad, "flowerChance", 16, 0, 64, "betterfoliage.lilypad.flowerChance");
        reedEnabled = Config.getBoolean(Category.reed, "enabled", true, "betterfoliage.enabled");
        reedHOffset = Config.getDouble(Category.reed, "hOffset", 0.2, 0.0, 0.4, "betterfoliage.hOffset");
        reedHeightMin = Config.getDouble(Category.reed, "heightMin", 2.0, 1.5, 3.5, "betterfoliage.minHeight");
        reedHeightMax = Config.getDouble(Category.reed, "heightMax", 2.5, 1.5, 3.5, "betterfoliage.maxHeight");
        reedPopulation = Config.getInt(Category.reed, "population", 32, 0, 64, "betterfoliage.population");
        reedHeightMin = Config.clampDoubleToMax(Category.reed, "heightMin", "heightMax");
        reedBiomeList = Config.getIntList(Category.reed, "reedBiomeList", reedBiomeList, "betterfoliage.reed.biomeList");
        reedShaderWind = Config.getBoolean(Category.reed, "shaderWind", true, "betterfoliage.shaderWind");
        algaeEnabled = Config.getBoolean(Category.algae, "enabled", true, "betterfoliage.enabled");
        algaeHOffset = Config.getDouble(Category.algae, "hOffset", 0.1, 0.0, 0.25, "betterfoliage.hOffset");
        algaeSize = Config.getDouble(Category.algae, "size", 1.0, 0.5, 1.5, "betterfoliage.size");
        algaeHeightMin = Config.getDouble(Category.algae, "heightMin", 0.5, 0.1, 1.5, "betterfoliage.minHeight");
        algaeHeightMax = Config.getDouble(Category.algae, "heightMax", 1.0, 0.1, 1.5, "betterfoliage.maxHeight");
        algaePopulation = Config.getInt(Category.algae, "population", 48, 0, 64, "betterfoliage.population");
        algaeHeightMin = Config.clampDoubleToMax(Category.algae, "heightMin", "heightMax");
        algaeBiomeList = Config.getIntList(Category.algae, "algaeBiomeList", algaeBiomeList, "betterfoliage.algae.biomeList");
        coralEnabled = Config.getBoolean(Category.coral, "enabled", true, "betterfoliage.enabled");
        coralShallowWater = Config.getBoolean(Category.coral, "shallowWater", false, "betterfoliage.coral.shallowWater");
        coralHOffset = Config.getDouble(Category.coral, "hOffset", 0.2, 0.0, 0.4, "betterfoliage.hOffset");
        coralVOffset = Config.getDouble(Category.coral, "vOffset", 0.1, 0.0, 0.4, "betterfoliage.vOffset");
        coralSize = Config.getDouble(Category.coral, "size", 0.7, 0.5, 1.5, "betterfoliage.coral.size");
        coralCrustSize = Config.getDouble(Category.coral, "crustSize", 1.4, 0.5, 1.5, "betterfoliage.coral.crustSize");
        coralChance = Config.getInt(Category.coral, "chance", 32, 0, 64, "betterfoliage.coral.chance");
        coralPopulation = Config.getInt(Category.coral, "population", 48, 0, 64, "betterfoliage.population");
        coralBiomeList = Config.getIntList(Category.coral, "coralBiomeList", coralBiomeList, "betterfoliage.coral.biomeList");
        leafFXEnabled = Config.getBoolean(Category.fallingLeaves, "enabled", true, "betterfoliage.enabled");
        leafFXSpeed = Config.getDouble(Category.fallingLeaves, "speed", 0.05, 0.01, 0.15, "betterfoliage.fallingLeaves.speed");
        leafFXWindStrength = Config.getDouble(Category.fallingLeaves, "windStrength", 0.5, 0.1, 2.0, "betterfoliage.fallingLeaves.windStrength");
        leafFXStormStrength = Config.getDouble(Category.fallingLeaves, "stormStrength", 0.8, 0.1, 2.0, "betterfoliage.fallingLeaves.stormStrength");
        leafFXSize = Config.getDouble(Category.fallingLeaves, "size", 0.75, 0.25, 1.5, "betterfoliage.fallingLeaves.size");
        leafFXChance = Config.getDouble(Category.fallingLeaves, "chance", 0.05, 0.001, 1.0, "betterfoliage.fallingLeaves.chance");
        leafFXPerturb = Config.getDouble(Category.fallingLeaves, "perturb", 0.25, 0.01, 1.0, "betterfoliage.fallingLeaves.perturb");
        leafFXLifetime = Config.getDouble(Category.fallingLeaves, "lifetime", 5.0, 1.0, 15.0, "betterfoliage.fallingLeaves.lifetime");
        Config.deleteKey(Category.fallingLeaves, "opacityHack");
        soulFXEnabled = Config.getBoolean(Category.risingSoul, "enabled", true, "betterfoliage.enabled");
        soulFXChance = Config.getDouble(Category.risingSoul, "chance", 0.02, 0.001, 1.0, "betterfoliage.risingSoul.chance");
        soulFXSpeed = Config.getDouble(Category.risingSoul, "speed", 0.1, 0.025, 0.25, "betterfoliage.risingSoul.speed");
        soulFXPerturb = Config.getDouble(Category.risingSoul, "perturb", 0.05, 0.01, 0.25, "betterfoliage.risingSoul.perturb");
        soulFXHeadSize = Config.getDouble(Category.risingSoul, "headSize", 1.0, 0.25, 1.5, "betterfoliage.risingSoul.headSize");
        soulFXTrailSize = Config.getDouble(Category.risingSoul, "trailSize", 0.75, 0.25, 1.5, "betterfoliage.risingSoul.trailSize");
        soulFXOpacity = Config.getDouble(Category.risingSoul, "opacity", 0.5, 0.05, 1.0, "betterfoliage.risingSoul.opacity");
        soulFXSizeDecay = Config.getDouble(Category.risingSoul, "sizeDecay", 0.97, 0.5, 1.0, "betterfoliage.risingSoul.sizeDecay");
        soulFXOpacityDecay = Config.getDouble(Category.risingSoul, "opacityDecay", 0.97, 0.5, 1.0, "betterfoliage.risingSoul.opacityDecay");
        soulFXLifetime = Config.getDouble(Category.risingSoul, "lifetime", 4.0, 1.0, 15.0, "betterfoliage.risingSoul.lifetime");
        soulFXTrailLength = Config.getInt(Category.risingSoul, "trailLength", 48, 2, 128, "betterfoliage.risingSoul.trailLength");
        soulFXTrailDensity = Config.getInt(Category.risingSoul, "trailDensity", 3, 1, 16, "betterfoliage.risingSoul.trailDensity");
        netherrackEnabled = Config.getBoolean(Category.netherrack, "enabled", true, "betterfoliage.enabled");
        netherrackHOffset = Config.getDouble(Category.netherrack, "hOffset", 0.2, 0.0, 0.4, "betterfoliage.hOffset");
        netherrackHeightMin = Config.getDouble(Category.netherrack, "heightMin", 0.6, 0.1, 1.5, "betterfoliage.minHeight");
        netherrackHeightMax = Config.getDouble(Category.netherrack, "heightMax", 0.8, 0.1, 1.5, "betterfoliage.maxHeight");
        netherrackSize = Config.getDouble(Category.netherrack, "size", 1.0, 0.5, 1.5, "betterfoliage.size");
        netherrackHeightMin = Config.clampDoubleToMax(Category.netherrack, "heightMin", "heightMax");
        ctxGrassClassicEnabled = Config.getBoolean(Category.connectedGrass, "classic", true, "betterfoliage.connectedGrass.classic");
        ctxGrassAggressiveEnabled = Config.getBoolean(Category.connectedGrass, "aggressive", true, "betterfoliage.connectedGrass.aggressive");
        Config.updateBlockMatcher(dirt, Category.blockTypes, "dirtWhitelist", "betterfoliage.blockTypes.dirtWhitelist", "dirtBlacklist", "betterfoliage.blockTypes.dirtBlacklist", new ResourceLocation("betterfoliage:classesDirtDefault.cfg"));
        Config.updateBlockMatcher(grass, Category.blockTypes, "grassWhitelist", "betterfoliage.blockTypes.grassWhitelist", "grassBlacklist", "betterfoliage.blockTypes.grassBlacklist", new ResourceLocation("betterfoliage:classesGrassDefault.cfg"));
        Config.updateBlockMatcher(leaves, Category.blockTypes, "leavesWhitelist", "betterfoliage.blockTypes.leavesWhitelist", "leavesBlacklist", "betterfoliage.blockTypes.leavesBlacklist", new ResourceLocation("betterfoliage:classesLeavesDefault.cfg"));
        Config.updateBlockMatcher(crops, Category.blockTypes, "cropWhitelist", "betterfoliage.blockTypes.cropWhitelist", "cropBlacklist", "betterfoliage.blockTypes.cropBlacklist", new ResourceLocation("betterfoliage:classesCropDefault.cfg"));
        rawConfig.getCategory(Category.extraLeaves.toString()).get("skewMode").setConfigEntryClass(AlternateTextBooleanEntry.class);
        rawConfig.getCategory(Category.reed.toString()).get("reedBiomeList").setConfigEntryClass(BiomeListConfigEntry.class);
        rawConfig.getCategory(Category.algae.toString()).get("algaeBiomeList").setConfigEntryClass(BiomeListConfigEntry.class);
        rawConfig.getCategory(Category.coral.toString()).get("coralBiomeList").setConfigEntryClass(BiomeListConfigEntry.class);
        for (Category category : Category.values()) {
            rawConfig.setCategoryLanguageKey(category.toString(), String.format("betterfoliage.%s", category.toString()));
        }
        Config.setOrder(Category.extraLeaves, "enabled", "skewMode", "hOffset", "vOffset", "size");
        Config.setOrder(Category.shortGrass, "enabled", "useGenerated", "hOffset", "heightMin", "heightMax", "size", "shaderWind");
        Config.setOrder(Category.lilypad, "enabled", "hOffset", "flowerChance");
        Config.setOrder(Category.reed, "enabled", "hOffset", "heightMin", "heightMax", "population", "biomeList", "shaderWind");
        Config.setOrder(Category.algae, "enabled", "hOffset", "heightMin", "heightMax", "size", "population", "biomeList");
        Config.setOrder(Category.coral, "enabled", "shallowWater", "hOffset", "vOffset", "size", "crustSize", "population", "chance", "biomeList");
        Config.setOrder(Category.netherrack, "enabled", "hOffset", "heightMin", "heightMax", "size");
        Config.setOrder(Category.fallingLeaves, "enabled", "chance", "size", "lifetime", "speed", "windStrength", "stormStrength", "perturb");
        Config.setOrder(Category.risingSoul, "enabled", "chance", "speed", "perturb", "headSize", "trailSize", "sizeDecay", "opacity", "opacityDecay", "lifetime", "trailLength", "trailDensity");
        Config.setOrder(Category.connectedGrass, "classic", "aggressive");
    }

    public static void setupDefaultBiomes() {
        List<BiomeGenBase> biomes = BiomeUtils.getAllBiomes();
        reedBiomeList = BiomeUtils.getFilteredBiomeIds(biomes, reedBiomeDefaults);
        algaeBiomeList = BiomeUtils.getFilteredBiomeIds(biomes, algaeBiomeDefaults);
        coralBiomeList = BiomeUtils.getFilteredBiomeIds(biomes, coralBiomeDefaults);
    }

    public static List<IConfigElement> getConfigRootElements() {
        LinkedList result = Lists.newLinkedList();
        for (Category category : Category.values()) {
            if (category == Category.connectedGrass) continue;
            ConfigElement element = new ConfigElement(rawConfig.getCategory(category.toString()));
            result.add(element);
        }
        return result;
    }

    protected static double getDouble(Category category, String key, double defaultValue, double min, double max, String langKey) {
        Property prop = rawConfig.get(category.toString(), key, defaultValue);
        prop.setMinValue(min);
        prop.setMaxValue(max);
        prop.setLanguageKey(langKey);
        return prop.getDouble();
    }

    protected static double clampDoubleToMax(Category category, String keySmaller, String keyLarger) {
        ConfigCategory cfgCat = rawConfig.getCategory(category.toString());
        Property smaller = cfgCat.get(keySmaller);
        Property larger = cfgCat.get(keyLarger);
        if (smaller.getDouble() > larger.getDouble()) {
            smaller.set(larger.getDouble());
        }
        return smaller.getDouble();
    }

    protected static int getInt(Category category, String key, int defaultValue, int min, int max, String langKey) {
        Property prop = rawConfig.get(category.toString(), key, defaultValue);
        prop.setMinValue(min);
        prop.setMaxValue(max);
        prop.setLanguageKey(langKey);
        return prop.getInt();
    }

    protected static List<Integer> getIntList(Category category, String key, List<Integer> defaultList, String langKey) {
        int[] defaults = new int[]{};
        if (defaultList != null) {
            defaults = new int[defaultList.size()];
            int idx = 0;
            for (Integer value : defaultList) {
                defaults[idx++] = value;
            }
        }
        Property prop = rawConfig.get(category.toString(), key, defaults);
        prop.setLanguageKey(langKey);
        int[] values = prop.getIntList();
        ArrayList result = Lists.newArrayListWithCapacity((int)values.length);
        for (int value : values) {
            result.add(value);
        }
        return result;
    }

    protected static boolean getBoolean(Category category, String key, boolean defaultValue, String langKey) {
        Property prop = rawConfig.get(category.toString(), key, defaultValue);
        prop.setLanguageKey(langKey);
        return prop.getBoolean();
    }

    protected static void updateBlockMatcher(BlockMatcher bm, Category category, String whitelistKey, String whitelistLangKey, String blacklistKey, String blacklistLangKey, ResourceLocation defaults) {
        LinkedList defaultWhitelist = Lists.newLinkedList();
        LinkedList defaultBlacklist = Lists.newLinkedList();
        BlockMatcher.loadDefaultLists(defaults, defaultBlacklist, defaultWhitelist);
        Property whitelist = rawConfig.get(category.toString(), whitelistKey, defaultWhitelist.toArray(new String[0]));
        Property blacklist = rawConfig.get(category.toString(), blacklistKey, defaultBlacklist.toArray(new String[0]));
        whitelist.setLanguageKey(whitelistLangKey);
        blacklist.setLanguageKey(blacklistLangKey);
        whitelist.setConfigEntryClass(NonVerboseArrayEntry.class);
        blacklist.setConfigEntryClass(NonVerboseArrayEntry.class);
        bm.updateClassLists(whitelist.getStringList(), blacklist.getStringList());
    }

    protected static void setOrder(Category category, String ... properties) {
        rawConfig.setCategoryPropertyOrder(category.toString(), (List)Lists.newArrayList((Object[])properties));
    }

    protected static void deleteKey(Category category, String key) {
        rawConfig.getCategory(category.toString()).remove((Object)key);
    }

    @SubscribeEvent
    public void handleConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("BetterFoliage")) {
            Config.updateValues();
            if (rawConfig.hasChanged()) {
                rawConfig.save();
            }
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
    }

    static {
        leaves = new BlockMatcher();
        crops = new BlockMatcher();
        dirt = new BlockMatcher();
        grass = new BlockMatcher();
        reedBiomeList = Lists.newArrayList();
        algaeBiomeList = Lists.newArrayList();
        coralBiomeList = Lists.newArrayList();
        reedBiomeDefaults = BiomeUtils.biomeTempRainFilter(Float.valueOf(0.4f), null, Float.valueOf(0.4f), null);
        algaeBiomeDefaults = BiomeUtils.biomeClassNameFilter("river", "ocean");
        coralBiomeDefaults = BiomeUtils.biomeClassNameFilter("river", "ocean", "beach");
    }

    public static enum Category {
        blockTypes,
        extraLeaves,
        shortGrass,
        cactus,
        lilypad,
        reed,
        algae,
        coral,
        netherrack,
        fallingLeaves,
        risingSoul,
        connectedGrass;

    }
}

