/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.common.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BiomeUtils {
    private BiomeUtils() {
    }

    public static List<BiomeGenBase> getAllBiomes() {
        ArrayList biomes = Lists.newArrayList((Iterable)Collections2.filter(Arrays.asList(BiomeGenBase.func_150565_n()), (Predicate)Predicates.notNull()));
        Collections.sort(biomes, new Comparator<BiomeGenBase>(){

            @Override
            public int compare(BiomeGenBase o1, BiomeGenBase o2) {
                return o1.field_76791_y.compareTo(o2.field_76791_y);
            }
        });
        return biomes;
    }

    public static Predicate<BiomeGenBase> biomeIdFilter(final List<Integer> biomeIdList) {
        return new Predicate<BiomeGenBase>(){

            public boolean apply(BiomeGenBase biome) {
                return biomeIdList.contains(biome.field_76756_M);
            }
        };
    }

    public static Function<BiomeGenBase, Integer> biomeIdTransform() {
        return new Function<BiomeGenBase, Integer>(){

            public Integer apply(BiomeGenBase input) {
                return input.field_76756_M;
            }
        };
    }

    public static Predicate<BiomeGenBase> biomeTempRainFilter(final Float minTemp, final Float maxTemp, final Float minRain, final Float maxRain) {
        return new Predicate<BiomeGenBase>(){

            public boolean apply(BiomeGenBase biome) {
                if (minTemp != null && biome.field_76750_F < minTemp.floatValue()) {
                    return false;
                }
                if (maxTemp != null && biome.field_76750_F > maxTemp.floatValue()) {
                    return false;
                }
                if (minRain != null && biome.field_76751_G < minRain.floatValue()) {
                    return false;
                }
                return maxRain == null || !(biome.field_76751_G > maxRain.floatValue());
            }
        };
    }

    public static Predicate<BiomeGenBase> biomeClassFilter(final Class<?> ... classList) {
        return new Predicate<BiomeGenBase>(){

            public boolean apply(BiomeGenBase biome) {
                for (Class clazz : classList) {
                    if (!clazz.isAssignableFrom(biome.getClass()) && !clazz.equals(biome.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<BiomeGenBase> biomeClassNameFilter(final String ... names) {
        return new Predicate<BiomeGenBase>(){

            public boolean apply(BiomeGenBase biome) {
                for (String name : names) {
                    if (!biome.getClass().getName().toLowerCase().contains(name.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static List<Integer> getFilteredBiomeIds(Collection<BiomeGenBase> biomes, Predicate<BiomeGenBase> filter) {
        return Lists.newArrayList((Iterable)Collections2.transform((Collection)Collections2.filter(biomes, filter), BiomeUtils.biomeIdTransform()));
    }
}

