/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.common.util;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import mods.betterfoliage.common.util.ResourceUtils;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockMatcher {
    public Set<Class<?>> whiteList = Sets.newHashSet();
    public Set<Class<?>> blackList = Sets.newHashSet();
    public Set<Integer> blockIDs = Sets.newHashSet();

    public boolean matchesClass(Block block) {
        for (Class<?> clazz : this.blackList) {
            if (!clazz.isAssignableFrom(block.getClass())) continue;
            return false;
        }
        for (Class<?> clazz : this.whiteList) {
            if (!clazz.isAssignableFrom(block.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean matchesID(int blockId) {
        return this.blockIDs.contains(blockId);
    }

    public boolean matchesID(Block block) {
        return this.blockIDs.contains(Block.field_149771_c.func_148757_b((Object)block));
    }

    public void updateClassLists(String[] newWhitelist, String[] newBlacklist) {
        this.whiteList.clear();
        for (String className : newWhitelist) {
            try {
                this.whiteList.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        this.blackList.clear();
        for (String className : newBlacklist) {
            try {
                this.blackList.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        this.updateBlockIDs();
    }

    public void updateBlockIDs() {
        this.blockIDs.clear();
        for (Block block : Block.field_149771_c) {
            if (!this.matchesClass(block)) continue;
            this.blockIDs.add(Block.field_149771_c.func_148757_b((Object)block));
        }
    }

    public static void loadDefaultLists(ResourceLocation defaults, Collection<String> blacklist, Collection<String> whitelist) {
        for (String line : ResourceUtils.getLines(defaults)) {
            if (line.startsWith("-")) {
                blacklist.add(line.substring(1));
                continue;
            }
            whitelist.add(line);
        }
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        if (event.world instanceof WorldClient) {
            this.updateBlockIDs();
        }
    }
}

