/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.common.util;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import mods.betterfoliage.BetterFoliage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ResourceUtils {
    private ResourceUtils() {
    }

    public static Map<String, IResourceManager> getDomainResourceManagers() {
        return ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).field_110548_a;
    }

    public static boolean resourceExists(ResourceLocation resourceLocation) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            if (resource != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void copyFromTextResource(ResourceLocation resourceLocation, File target) throws IOException {
        IResource defaults = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
        BufferedReader reader = new BufferedReader(new InputStreamReader(defaults.func_110527_b(), Charsets.UTF_8));
        FileWriter writer = new FileWriter(target);
        String line = reader.readLine();
        while (line != null) {
            writer.write(line + System.lineSeparator());
            line = reader.readLine();
        }
        reader.close();
        writer.close();
    }

    public static Iterable<String> getLines(ResourceLocation resource) {
        BufferedReader reader = null;
        ArrayList result = Lists.newArrayList();
        try {
            reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b(), Charsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("//")) {
                    result.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            BetterFoliage.log.warn(String.format("Error reading resource %s", resource.toString()));
            return Lists.newArrayList();
        }
        return result;
    }

    public static Iterable<ModelBlock> iterateParents(final Map<ResourceLocation, ModelBlock> models, final ResourceLocation startModel) {
        return new Iterable<ModelBlock>(){

            @Override
            public Iterator<ModelBlock> iterator() {
                return new Iterator<ModelBlock>(){
                    protected ModelBlock currentModel;
                    {
                        this.currentModel = (ModelBlock)models.get(startModel);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentModel != null;
                    }

                    @Override
                    public ModelBlock next() {
                        ModelBlock result = this.currentModel;
                        this.currentModel = (ModelBlock)models.get(this.currentModel.func_178305_e());
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Integer calculateTextureColor(TextureAtlasSprite icon) {
        ResourceLocation locationNoDirs = new ResourceLocation(icon.func_94215_i());
        ResourceLocation locationWithDirs = new ResourceLocation(locationNoDirs.func_110624_b(), String.format("textures/%s.png", locationNoDirs.func_110623_a()));
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(locationWithDirs).func_110527_b());
            int numOpaque = 0;
            float sumHueX = 0.0f;
            float sumHueY = 0.0f;
            float sumSaturation = 0.0f;
            float sumBrightness = 0.0f;
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int pixel = image.getRGB(x, y);
                    int alpha = pixel >> 24 & 0xFF;
                    float[] hsbVals = Color.RGBtoHSB(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF, null);
                    if (alpha != 255) continue;
                    ++numOpaque;
                    sumHueX = (float)((double)sumHueX + Math.cos(((double)hsbVals[0] - 0.5) * 2.0 * Math.PI));
                    sumHueY = (float)((double)sumHueY + Math.sin(((double)hsbVals[0] - 0.5) * 2.0 * Math.PI));
                    sumSaturation += hsbVals[1];
                    sumBrightness += hsbVals[2];
                }
            }
            float avgHue = (float)(Math.atan2(sumHueY, sumHueX) / (Math.PI * 2) + 0.5);
            return Color.HSBtoRGB(avgHue, sumSaturation / (float)numOpaque, sumBrightness / (float)numOpaque);
        }
        catch (IOException e) {
            return null;
        }
    }
}

