/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.common.util;

import com.google.common.collect.Lists;
import java.util.List;
import mods.betterfoliage.common.util.ResourceUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureMatcher {
    public static final String DEFAULT_NAME = "default";
    public List<TextureMapping> mappings = Lists.newLinkedList();

    public String get(TextureAtlasSprite icon) {
        for (TextureMapping mapping : this.mappings) {
            if (!mapping.matches(icon)) continue;
            return mapping.textureType;
        }
        return DEFAULT_NAME;
    }

    public void loadMappings(ResourceLocation resource) {
        this.mappings = Lists.newLinkedList();
        for (String line : ResourceUtils.getLines(resource)) {
            String[] lineSplit = line.split("=");
            if (lineSplit.length != 2) continue;
            String[] match = lineSplit[0].split(":");
            if (match.length == 2) {
                this.mappings.add(new TextureMapping(match[0], match[1], lineSplit[1]));
                continue;
            }
            if (match.length != 1) continue;
            this.mappings.add(new TextureMapping(null, match[0], lineSplit[1]));
        }
    }

    public static class TextureMapping {
        public String matchDomain;
        public String matchName;
        public String textureType;

        public TextureMapping(String matchDomain, String matchName, String textureType) {
            this.matchDomain = matchDomain;
            this.matchName = matchName;
            this.textureType = textureType;
        }

        public boolean matches(TextureAtlasSprite icon) {
            ResourceLocation iconLocation = new ResourceLocation(icon.func_94215_i());
            if (this.matchDomain != null && !this.matchDomain.equals(iconLocation.func_110624_b())) {
                return false;
            }
            return iconLocation.func_110623_a().contains(this.matchName);
        }
    }
}

