/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.loader;

import com.google.common.collect.ImmutableList;
import mods.betterfoliage.loader.DeobfHelper;
import mods.betterfoliage.loader.MethodTransformerBase;
import mods.betterfoliage.loader.TransformModelLoader;
import mods.betterfoliage.loader.TransformRandomDisplayTick;
import mods.betterfoliage.loader.TransformRenderChunk;
import mods.betterfoliage.loader.TransformShaderModBlockIdOverride;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class BetterFoliageTransformer
implements IClassTransformer {
    protected Iterable<MethodTransformerBase> transformers = ImmutableList.of((Object)new TransformModelLoader(), (Object)new TransformShaderModBlockIdOverride(), (Object)new TransformRandomDisplayTick(), (Object)new TransformRenderChunk());
    protected Logger logger = LogManager.getLogger((String)this.getClass().getSimpleName());

    public BetterFoliageTransformer() {
        String mcVersion = FMLInjectionData.data()[4].toString();
        if (!ImmutableList.of((Object)"1.8").contains((Object)mcVersion)) {
            this.logger.warn(String.format("Unsupported Minecraft version %s", mcVersion));
        }
        DeobfHelper.init();
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean hasTransformed = false;
        block2: for (MethodTransformerBase transformer : this.transformers) {
            if (!transformedName.equals(transformer.getClassName())) continue;
            this.logger.debug(String.format("Found class: %s -> %s", name, transformedName));
            this.logger.debug(String.format("Searching signature: OBF = %s, MCP = %s", DeobfHelper.transformSignature(transformer.getSignature()), transformer.getSignature()));
            for (MethodNode methodNode : classNode.methods) {
                this.logger.trace(String.format("Checking method: %s, sig: %s", methodNode.name, methodNode.desc));
                Boolean isObfuscated = null;
                if (methodNode.name.equals(transformer.getMethodName()) && methodNode.desc.equals(transformer.getSignature())) {
                    isObfuscated = false;
                } else if (methodNode.name.equals(DeobfHelper.transformElementName(transformer.getMethodName())) && methodNode.desc.equals(DeobfHelper.transformSignature(transformer.getSignature()))) {
                    isObfuscated = true;
                }
                if (isObfuscated == null) continue;
                hasTransformed = true;
                try {
                    transformer.transform(methodNode, isObfuscated);
                    this.logger.info(String.format("%s: SUCCESS", transformer.getLogMessage()));
                }
                catch (Exception e) {
                    this.logger.info(String.format("%s: FAILURE", transformer.getLogMessage()));
                }
                continue block2;
            }
        }
        ClassWriter writer = new ClassWriter(0);
        if (hasTransformed) {
            classNode.accept((ClassVisitor)writer);
        }
        return !hasTransformed ? basicClass : writer.toByteArray();
    }
}

