/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.loader;

import mods.betterfoliage.loader.DeobfHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class MethodTransformerBase {
    public abstract String getClassName();

    public abstract String getMethodName();

    public abstract String getSignature();

    public abstract String getLogMessage();

    public abstract void transform(MethodNode var1, boolean var2);

    protected static String className(String className, boolean isObfuscated) {
        return isObfuscated ? DeobfHelper.transformClassName(className) : className;
    }

    protected static String element(String fieldName, boolean isObfuscated) {
        return isObfuscated ? DeobfHelper.transformElementName(fieldName) : fieldName;
    }

    protected static String signature(String signature, boolean isObfuscated) {
        return isObfuscated ? DeobfHelper.transformSignature(signature) : signature;
    }

    protected AbstractInsnNode findNext(AbstractInsnNode start, IInstructionMatch match) {
        AbstractInsnNode current;
        for (current = start; current != null && !match.matches(current); current = current.getNext()) {
        }
        return current;
    }

    protected AbstractInsnNode findPrevious(AbstractInsnNode start, IInstructionMatch match) {
        AbstractInsnNode current;
        for (current = start; current != null && !match.matches(current); current = current.getPrevious()) {
        }
        return current;
    }

    protected IInstructionMatch matchInvokeAny() {
        return new IInstructionMatch(){

            @Override
            public boolean matches(AbstractInsnNode node) {
                return node instanceof MethodInsnNode;
            }
        };
    }

    protected IInstructionMatch matchInvokeMethod(final String methodName) {
        return new IInstructionMatch(){

            @Override
            public boolean matches(AbstractInsnNode node) {
                return node instanceof MethodInsnNode && methodName.equals(((MethodInsnNode)node).name);
            }
        };
    }

    protected IInstructionMatch matchInvokeMethod(final String owner, final String methodName) {
        return new IInstructionMatch(){

            @Override
            public boolean matches(AbstractInsnNode node) {
                return node instanceof MethodInsnNode && methodName.equals(((MethodInsnNode)node).name) && owner.equals(((MethodInsnNode)node).owner);
            }
        };
    }

    protected IInstructionMatch matchOpcode(final int opcode) {
        return new IInstructionMatch(){

            @Override
            public boolean matches(AbstractInsnNode node) {
                return node.getOpcode() == opcode;
            }
        };
    }

    protected IInstructionMatch matchStore(int opcode, final int num) {
        return new IInstructionMatch(){

            @Override
            public boolean matches(AbstractInsnNode node) {
                return node instanceof VarInsnNode && num == ((VarInsnNode)node).var;
            }
        };
    }

    protected void insertAfter(InsnList insnList, AbstractInsnNode node, AbstractInsnNode ... added) {
        InsnList listAdd = new InsnList();
        for (AbstractInsnNode inst : added) {
            listAdd.add(inst);
        }
        insnList.insert(node, listAdd);
    }

    protected void insertBefore(InsnList insnList, AbstractInsnNode node, AbstractInsnNode ... added) {
        InsnList listAdd = new InsnList();
        for (AbstractInsnNode inst : added) {
            listAdd.add(inst);
        }
        insnList.insertBefore(node, listAdd);
    }

    public static interface IInstructionMatch {
        public boolean matches(AbstractInsnNode var1);
    }
}

