/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import mods.betterfoliage.client.PerturbationSource;
import mods.betterfoliage.client.render.BlockShadingData;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BFAbstractRenderer
extends BlockModelRenderer {
    public BlockShadingData shadingData = new BlockShadingData(this);
    public PerturbationSource random = new PerturbationSource();

    public abstract boolean renderFeatureForBlock(IBlockAccess var1, IBlockState var2, BlockPos var3, WorldRenderer var4, boolean var5);

    public static int getAoIndexForFaces(EnumFacing face, EnumFacing axis1, EnumFacing axis2) {
        BlockModelRenderer.EnumNeighborInfo neighborInfo = BlockModelRenderer.EnumNeighborInfo.func_178273_a((EnumFacing)face);
        BlockModelRenderer.VertexTranslations vertexTrans = BlockModelRenderer.VertexTranslations.func_178184_a((EnumFacing)face);
        boolean top = false;
        boolean left = false;
        if (axis1 == neighborInfo.field_178276_g[0] || axis1 == neighborInfo.field_178276_g[0]) {
            top = true;
        }
        if (axis1 == neighborInfo.field_178276_g[2] || axis1 == neighborInfo.field_178276_g[2]) {
            left = true;
        }
        if (top && !left) {
            return vertexTrans.field_178191_g;
        }
        if (top && left) {
            return vertexTrans.field_178200_h;
        }
        if (!top && left) {
            return vertexTrans.field_178201_i;
        }
        if (!top && !left) {
            return vertexTrans.field_178198_j;
        }
        return 0;
    }

    protected int getSemiRandomFromPos(BlockPos pos, int seed) {
        long lx = pos.func_177958_n();
        long ly = pos.func_177956_o();
        long lz = pos.func_177952_p();
        long value = lx * lx + ly * ly + lz * lz + lx * ly + ly * lz + lz * lx + (long)(seed * seed) & 0x3FL;
        value = 3L * lx * value + 5L * ly * value + 7L * lz * value + (long)(11 * seed) & 0x3FL;
        return (int)value;
    }

    protected Double3 getChunkBase(BlockPos pos) {
        int cX = pos.func_177958_n() >= 0 ? pos.func_177958_n() / 16 : (pos.func_177958_n() + 1) / 16 - 1;
        int cY = pos.func_177956_o() / 16;
        int cZ = pos.func_177952_p() >= 0 ? pos.func_177952_p() / 16 : (pos.func_177952_p() + 1) / 16 - 1;
        return new Double3(cX * 16, cY * 16, cZ * 16);
    }

    public class BFAmbientOcclusionFace
    extends BlockModelRenderer.AmbientOcclusionFace {
        public BFAmbientOcclusionFace() {
            super((BlockModelRenderer)BFAbstractRenderer.this);
        }
    }
}

