/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.aimbow.aiming;

import java.util.ArrayList;
import net.famzangl.minecraft.aimbow.aiming.BowColissionSolver;
import net.famzangl.minecraft.aimbow.aiming.ColissionData;
import net.famzangl.minecraft.aimbow.aiming.RayData;
import net.famzangl.minecraft.aimbow.aiming.ThrowableColissionSolver;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public abstract class ColissionSolver {
    protected final Minecraft minecraft;
    protected final EntityLivingBase shootingEntity;
    private final ArrayList<RayData> simulated = new ArrayList();
    private ArrayList<ColissionData> colissions;

    public ColissionSolver(Minecraft mc, EntityLivingBase renderViewEntity) {
        this.minecraft = mc;
        this.shootingEntity = renderViewEntity;
    }

    private void runTick(int tick) {
        for (RayData s : this.simulated) {
            if (s.isDead()) continue;
            s.moveTick();
            MovingObjectPosition hit = this.computeHit(s, tick);
            if (hit == null) continue;
            this.colissions.add(new ColissionData(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, hit.field_72308_g, tick));
            s.setDead(true);
        }
    }

    protected abstract MovingObjectPosition computeHit(RayData var1, int var2);

    private void generateRays(Entity entity) {
        this.simulated.clear();
        RayData data = this.generateRayData();
        data.shootFrom(entity);
        this.simulated.add(data);
    }

    public ArrayList<ColissionData> computeCurrentColissionPoints() {
        this.colissions = new ArrayList();
        this.generateRays(this.minecraft.func_175606_aa());
        this.run();
        return this.colissions;
    }

    public ArrayList<ColissionData> computeColissionWithLook(Vec3 look) {
        this.colissions = new ArrayList();
        this.simulated.clear();
        RayData data = this.generateRayData();
        data.shootFromTowards((Entity)this.shootingEntity, look);
        this.simulated.add(data);
        this.run();
        return this.colissions;
    }

    protected abstract RayData generateRayData();

    private void run() {
        for (int i = 0; i < 200; ++i) {
            this.runTick(i);
        }
    }

    public static ColissionSolver forItem(ItemStack heldItem, Minecraft mc) {
        if (heldItem == null) {
            return null;
        }
        if (heldItem.func_77973_b() == Items.field_151126_ay || heldItem.func_77973_b() == Items.field_151110_aK) {
            return new ThrowableColissionSolver(mc, (EntityLivingBase)mc.func_175606_aa());
        }
        if (heldItem.func_77973_b() == Items.field_151031_f) {
            return new BowColissionSolver(mc, (EntityLivingBase)mc.func_175606_aa());
        }
        return null;
    }

    public float getGravity() {
        return this.generateRayData().getGravity();
    }

    public abstract float getVelocity();
}

